"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OverviewTableContainer = OverviewTableContainer;
var _react = _interopRequireDefault(require("react"));
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _use_breakpoints = require("../../../hooks/use_breakpoints");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761044620168364099/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/apm/public/components/shared/overview_table_container/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/**
 * The height for a table on a overview page. Is the height of a 5-row basic
 * table.
 */
const tableHeight = 282;

/**
 * A container for the table. Sets height and flex properties on the EUI Basic
 * Table contained within and the first child div of that. This makes it so the
 * pagination controls always stay fixed at the bottom in the same position.
 *
 * Only do this when we're at a non-mobile breakpoint.
 *
 * Hide the empty message when we don't yet have any items and are still not initiated.
 */
const OverviewTableContainerDiv = _styled.default.div`
  ${({
  fixedHeight,
  shouldUseMobileLayout
}) => shouldUseMobileLayout || !fixedHeight ? '' : `
  min-height: ${tableHeight}px;
  display: flex;
  flex-direction: column;

  .euiBasicTable {
    display: flex;
    flex-direction: column;
    flex-grow: 1;

    /* Align the pagination to the bottom of the card */
    > :last-child {
      margin-top: auto;
    }
  `}

  .euiTableRowCell {
    visibility: ${({
  isEmptyAndNotInitiated
}) => isEmptyAndNotInitiated ? 'hidden' : 'visible'};
  }
`;
function OverviewTableContainer({
  children,
  fixedHeight,
  isEmptyAndNotInitiated
}) {
  const {
    isMedium
  } = (0, _use_breakpoints.useBreakpoints)();
  return /*#__PURE__*/_react.default.createElement(OverviewTableContainerDiv, {
    fixedHeight: fixedHeight,
    isEmptyAndNotInitiated: isEmptyAndNotInitiated,
    shouldUseMobileLayout: isMedium,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 5
    }
  }, children);
}