"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DroppedSpansWarning = DroppedSpansWarning;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _use_apm_plugin_context = require("../../../../../../../context/apm_plugin/use_apm_plugin_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761044620168364099/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/transaction_details/waterfall_with_summary/waterfall_container/waterfall/transaction_flyout/dropped_spans_warning.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function DroppedSpansWarning({
  transactionDoc
}) {
  var _transactionDoc$trans;
  const {
    docLinks
  } = (0, _use_apm_plugin_context.useApmPluginContext)().core;
  const dropped = (_transactionDoc$trans = transactionDoc.transaction.span_count) === null || _transactionDoc$trans === void 0 ? void 0 : _transactionDoc$trans.dropped;
  if (!dropped) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 22,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 23,
      columnNumber: 7
    }
  }, _i18n.i18n.translate('xpack.apm.transactionDetails.transFlyout.callout.agentDroppedSpansMessage', {
    defaultMessage: 'The APM agent that reported this transaction dropped {dropped} spans or more based on its configuration.',
    values: {
      dropped
    }
  }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "apmDroppedSpansWarningLearnMoreAboutDroppedSpansLink",
    href: docLinks.links.apm.droppedTransactionSpans,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.apm.transactionDetails.transFlyout.callout.learnMoreAboutDroppedSpansLinkText', {
    defaultMessage: 'Learn more about dropped spans.'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 7
    }
  }));
}