"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SyncBadge = SyncBadge;
exports.getSyncLabel = getSyncLabel;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761044620168364099/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/transaction_details/waterfall_with_summary/waterfall_container/waterfall/badge/sync_badge.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const BLOCKING_LABEL = _i18n.i18n.translate('xpack.apm.transactionDetails.syncBadgeBlocking', {
  defaultMessage: 'blocking'
});
const ASYNC_LABEL = _i18n.i18n.translate('xpack.apm.transactionDetails.syncBadgeAsync', {
  defaultMessage: 'async'
});
const TOOLTIP_CONTENT = _i18n.i18n.translate('xpack.apm.transactionDetails.syncBadgeTooltip', {
  defaultMessage: 'Indicates whether the span was executed synchronously or asynchronously.'
});

// true will show blocking, false will show async.
// otel doesn't set sync field
const agentsSyncMap = {
  nodejs: true,
  'js-base': true,
  'rum-js': true,
  php: false,
  python: false,
  dotnet: false,
  'iOS/swift': false,
  ruby: false,
  java: false,
  go: false
};
function getSyncLabel(agentName, sync) {
  if (sync === undefined) {
    return;
  }
  const agentSyncValue = agentsSyncMap[agentName];
  if (sync && agentSyncValue) {
    return BLOCKING_LABEL;
  }
  if (!sync && !agentSyncValue) {
    return ASYNC_LABEL;
  }
}
function SyncBadge({
  sync,
  agentName
}) {
  const syncLabel = getSyncLabel(agentName, sync);
  if (!syncLabel) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: TOOLTIP_CONTENT,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    tabIndex: 0,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 7
    }
  }, syncLabel));
}