"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexStatsPerService = IndexStatsPerService;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _use_apm_plugin_context = require("../../../../context/apm_plugin/use_apm_plugin_context");
var _i18n2 = require("../../../../../common/i18n");
var _formatters = require("../../../../../common/utils/formatters");
var _use_fetcher = require("../../../../hooks/use_fetcher");
var _size_label = require("./size_label");
var _get_storage_explorer_links = require("../get_storage_explorer_links");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761044620168364099/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/storage_explorer/services_table/index_stats_per_service.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function IndexStatsPerService({
  indicesStats,
  status
}) {
  const {
    core
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  const columns = [{
    field: 'indexName',
    name: _i18n.i18n.translate('xpack.apm.storageExplorer.indicesStats.indexName', {
      defaultMessage: 'Name'
    }),
    sortable: true
  }, {
    field: 'primary',
    name: _i18n.i18n.translate('xpack.apm.storageExplorer.indicesStats.primaries', {
      defaultMessage: 'Primaries'
    }),
    render: (_, {
      primary
    }) => primary !== null && primary !== void 0 ? primary : _i18n2.NOT_AVAILABLE_LABEL,
    sortable: true
  }, {
    field: 'replica',
    name: _i18n.i18n.translate('xpack.apm.storageExplorer.indicesStats.replicas', {
      defaultMessage: 'Replicas'
    }),
    render: (_, {
      replica
    }) => replica !== null && replica !== void 0 ? replica : _i18n2.NOT_AVAILABLE_LABEL,
    sortable: true
  }, {
    field: 'numberOfDocs',
    name: _i18n.i18n.translate('xpack.apm.storageExplorer.indicesStats.numberOfDocs', {
      defaultMessage: 'Docs count'
    }),
    render: (_, {
      numberOfDocs
    }) => (0, _formatters.asInteger)(numberOfDocs),
    sortable: true
  }, {
    field: 'size',
    name: /*#__PURE__*/_react.default.createElement(_size_label.SizeLabel, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 66,
        columnNumber: 13
      }
    }),
    render: (_, {
      size
    }) => {
      var _asDynamicBytes;
      return (_asDynamicBytes = (0, _formatters.asDynamicBytes)(size)) !== null && _asDynamicBytes !== void 0 ? _asDynamicBytes : _i18n2.NOT_AVAILABLE_LABEL;
    },
    sortable: true
  }, {
    field: 'dataStream',
    name: _i18n.i18n.translate('xpack.apm.storageExplorer.indicesStats.dataStream', {
      defaultMessage: 'Data stream'
    }),
    render: (_, {
      dataStream
    }) => {
      var _EuiLink;
      return (_EuiLink = /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "storageExplorerIndexManagementDataStreamLink",
        href: (0, _get_storage_explorer_links.getIndexManagementHref)(core, dataStream),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 77,
          columnNumber: 11
        }
      }, dataStream)) !== null && _EuiLink !== void 0 ? _EuiLink : _i18n2.NOT_AVAILABLE_LABEL;
    },
    sortable: true
  }, {
    field: 'lifecyclePhase',
    name: _i18n.i18n.translate('xpack.apm.storageExplorer.indicesStats.lifecyclePhase', {
      defaultMessage: 'Lifecycle phase'
    }),
    render: (_, {
      lifecyclePhase
    }) => lifecyclePhase !== null && lifecyclePhase !== void 0 ? lifecyclePhase : _i18n2.NOT_AVAILABLE_LABEL,
    sortable: true
  }];
  const loading = (0, _use_fetcher.isPending)(status);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h5", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.apm.storageExplorer.indicesStats.title', {
    defaultMessage: 'Indices breakdown'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    tableCaption: _i18n.i18n.translate('xpack.apm.storageExplorer.indicesStats.table.caption', {
      defaultMessage: 'Storage explorer indices breakdown'
    }),
    items: indicesStats,
    columns: columns,
    pagination: true,
    sorting: true,
    loading: loading,
    "data-test-subj": "storageExplorerIndicesStatsTable",
    error: status === _use_fetcher.FETCH_STATUS.FAILURE ? _i18n.i18n.translate('xpack.apm.storageExplorer.indicesStats.table.errorMessage', {
      defaultMessage: 'Failed to fetch'
    }) : '',
    message: loading ? _i18n.i18n.translate('xpack.apm.storageExplorer.indicesStats.table.loading', {
      defaultMessage: 'Loading...'
    }) : _i18n.i18n.translate('xpack.apm.storageExplorer.indicesStats.table.noResults', {
      defaultMessage: 'No data found'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 9
    }
  })));
}