"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServiceInventory = ServiceInventory;
var _eui = require("@elastic/eui");
var _ebtTools = require("@kbn/ebt-tools");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _uuid = require("uuid");
var _document_type = require("../../../../common/document_type");
var _service_inventory = require("../../../../common/service_inventory");
var _use_anomaly_detection_jobs_context = require("../../../context/anomaly_detection_jobs/use_anomaly_detection_jobs_context");
var _use_apm_plugin_context = require("../../../context/apm_plugin/use_apm_plugin_context");
var _use_apm_params = require("../../../hooks/use_apm_params");
var _use_debounce = require("../../../hooks/use_debounce");
var _use_fetcher = require("../../../hooks/use_fetcher");
var _use_local_storage = require("../../../hooks/use_local_storage");
var _use_preferred_data_source_and_bucket_size = require("../../../hooks/use_preferred_data_source_and_bucket_size");
var _use_progressive_fetcher = require("../../../hooks/use_progressive_fetcher");
var _use_time_range = require("../../../hooks/use_time_range");
var _ml_callout = require("../../shared/ml_callout");
var _search_bar = require("../../shared/search_bar/search_bar");
var _get_comparison_options = require("../../shared/time_comparison/get_comparison_options");
var _apm_services_table = require("./service_list/apm_services_table");
var _order_service_items = require("./service_list/order_service_items");
var _traces_in_discover_callout = require("./traces_in_discover_callout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761044620168364099/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/service_inventory/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const INITIAL_PAGE_SIZE = 25;
const INITIAL_DATA = {
  requestId: '',
  items: [],
  serviceOverflowCount: 0,
  maxCountExceeded: false
};
function useServicesMainStatisticsFetcher(searchQuery) {
  var _preferred$source;
  const {
    query: {
      rangeFrom,
      rangeTo,
      environment,
      kuery,
      serviceGroup,
      page = 0,
      pageSize = INITIAL_PAGE_SIZE,
      sortDirection,
      sortField
    }
  } = (0, _use_apm_params.useApmParams)('/services');
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const preferred = (0, _use_preferred_data_source_and_bucket_size.usePreferredDataSourceAndBucketSize)({
    start,
    end,
    kuery,
    type: _document_type.ApmDocumentType.ServiceTransactionMetric,
    numBuckets: 20
  });
  const shouldUseDurationSummary = !!(preferred !== null && preferred !== void 0 && (_preferred$source = preferred.source) !== null && _preferred$source !== void 0 && _preferred$source.hasDurationSummaryField);
  const {
    data = INITIAL_DATA,
    status
  } = (0, _use_progressive_fetcher.useProgressiveFetcher)(callApmApi => {
    if (preferred) {
      return callApmApi('GET /internal/apm/services', {
        params: {
          query: {
            environment,
            kuery,
            start,
            end,
            serviceGroup,
            useDurationSummary: shouldUseDurationSummary,
            documentType: preferred.source.documentType,
            rollupInterval: preferred.source.rollupInterval,
            searchQuery
          }
        }
      }).then(mainStatisticsData => {
        return {
          requestId: (0, _uuid.v4)(),
          ...mainStatisticsData
        };
      });
    }
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [environment, kuery, start, end, serviceGroup, preferred, searchQuery,
  // not used, but needed to update the requestId to call the details statistics API when table options are updated
  page, pageSize, sortField, sortDirection]);
  return {
    mainStatisticsData: data,
    mainStatisticsStatus: status
  };
}
function useServicesDetailedStatisticsFetcher({
  renderedItems
}) {
  const {
    query: {
      rangeFrom,
      rangeTo,
      environment,
      kuery,
      offset,
      comparisonEnabled
    }
  } = (0, _use_apm_params.useApmParams)('/services');
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const dataSourceOptions = (0, _use_preferred_data_source_and_bucket_size.usePreferredDataSourceAndBucketSize)({
    start,
    end,
    kuery,
    type: _document_type.ApmDocumentType.ServiceTransactionMetric,
    numBuckets: 20
  });
  const itemsToFetch = (0, _react.useMemo)(() => renderedItems.map(({
    serviceName
  }) => serviceName), [renderedItems]);
  const comparisonFetch = (0, _use_progressive_fetcher.useProgressiveFetcher)(callApmApi => {
    if (start && end && itemsToFetch.length > 0 && dataSourceOptions) {
      return callApmApi('POST /internal/apm/services/detailed_statistics', {
        params: {
          query: {
            environment,
            kuery,
            start,
            end,
            offset: comparisonEnabled && (0, _get_comparison_options.isTimeComparison)(offset) ? offset : undefined,
            documentType: dataSourceOptions.source.documentType,
            rollupInterval: dataSourceOptions.source.rollupInterval,
            bucketSizeInSeconds: dataSourceOptions.bucketSizeInSeconds
          },
          body: {
            // Service name is sorted to guarantee the same order every time this API is called so the result can be cached.
            serviceNames: JSON.stringify(itemsToFetch)
          }
        }
      });
    }
  },
  // only fetches detailed statistics when requestId is invalidated by main statistics api call or offset is changed

  // eslint-disable-next-line react-hooks/exhaustive-deps
  [itemsToFetch, offset, comparisonEnabled], {
    preservePreviousData: false
  });
  return {
    comparisonFetch
  };
}
function ServiceInventory() {
  var _mainStatisticsData$s, _useApmPluginContext$, _mainStatisticsData$m;
  const [debouncedSearchQuery, setDebouncedSearchQuery] = (0, _use_debounce.useStateDebounced)('');
  const {
    onPageReady
  } = (0, _ebtTools.usePerformanceContext)();
  const mainStatisticsFetch = useServicesMainStatisticsFetcher(debouncedSearchQuery);
  const [renderedItems, setRenderedItems] = (0, _react.useState)([]);
  const {
    mainStatisticsData,
    mainStatisticsStatus
  } = mainStatisticsFetch;
  const {
    query: {
      rangeFrom,
      rangeTo
    }
  } = (0, _use_apm_params.useApmParams)('/services');
  const displayHealthStatus = mainStatisticsData.items.some(item => 'healthStatus' in item);
  const serviceOverflowCount = (_mainStatisticsData$s = mainStatisticsData === null || mainStatisticsData === void 0 ? void 0 : mainStatisticsData.serviceOverflowCount) !== null && _mainStatisticsData$s !== void 0 ? _mainStatisticsData$s : 0;
  const displayAlerts = mainStatisticsData.items.some(item => _service_inventory.ServiceInventoryFieldName.AlertsCount in item);
  const tiebreakerField = _service_inventory.ServiceInventoryFieldName.Throughput;
  const initialSortField = displayHealthStatus ? _service_inventory.ServiceInventoryFieldName.HealthStatus : tiebreakerField;
  const initialSortDirection = 'desc';
  const {
    comparisonFetch
  } = useServicesDetailedStatisticsFetcher({
    renderedItems
  });
  const {
    anomalyDetectionSetupState
  } = (0, _use_anomaly_detection_jobs_context.useAnomalyDetectionJobsContext)();
  const [userHasDismissedCallout, setUserHasDismissedCallout] = (0, _use_local_storage.useLocalStorage)(`apm.userHasDismissedServiceInventoryMlCallout.${anomalyDetectionSetupState}`, false);
  const displayMlCallout = !userHasDismissedCallout && (0, _ml_callout.shouldDisplayMlCallout)(anomalyDetectionSetupState);
  const noItemsMessage = (0, _react.useMemo)(() => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      title: /*#__PURE__*/_react.default.createElement("div", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 217,
          columnNumber: 11
        }
      }, _i18n.i18n.translate('xpack.apm.servicesTable.notFoundLabel', {
        defaultMessage: 'No services found'
      })),
      titleSize: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 215,
        columnNumber: 7
      }
    });
  }, []);
  const mlCallout = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 229,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_ml_callout.MLCallout, {
    isOnSettingsPage: false,
    anomalyDetectionSetupState: anomalyDetectionSetupState,
    onDismiss: () => setUserHasDismissedCallout(true),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 230,
      columnNumber: 7
    }
  }));
  const sortFn = (0, _react.useCallback)((itemsToSort, sortField, sortDirection) => {
    return (0, _order_service_items.orderServiceItems)({
      items: itemsToSort,
      primarySortField: sortField,
      sortDirection,
      tiebreakerField
    });
  }, [tiebreakerField]);

  // TODO verify this with AI team
  const setScreenContext = (_useApmPluginContext$ = (0, _use_apm_plugin_context.useApmPluginContext)().observabilityAIAssistant) === null || _useApmPluginContext$ === void 0 ? void 0 : _useApmPluginContext$.service.setScreenContext;
  (0, _react.useEffect)(() => {
    if (!setScreenContext) {
      return;
    }
    if ((0, _use_fetcher.isFailure)(mainStatisticsStatus)) {
      return setScreenContext({
        screenDescription: 'The services have failed to load'
      });
    }
    if ((0, _use_fetcher.isPending)(mainStatisticsStatus)) {
      return setScreenContext({
        screenDescription: 'The services are still loading'
      });
    }
    return setScreenContext({
      data: [{
        name: 'services',
        description: 'The list of services that the user is looking at',
        value: mainStatisticsData.items
      }]
    });
  }, [mainStatisticsStatus, mainStatisticsData.items, setScreenContext]);
  (0, _react.useEffect)(() => {
    if (mainStatisticsStatus === _use_fetcher.FETCH_STATUS.SUCCESS && comparisonFetch.status === _use_fetcher.FETCH_STATUS.SUCCESS) {
      onPageReady({
        meta: {
          rangeFrom,
          rangeTo
        }
      });
    }
  }, [mainStatisticsStatus, comparisonFetch.status, onPageReady, rangeFrom, rangeTo]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_search_bar.SearchBar, {
    showTimeComparison: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 293,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 294,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_traces_in_discover_callout.TracesInDiscoverCallout, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 295,
      columnNumber: 9
    }
  }), displayMlCallout && mlCallout, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 297,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_apm_services_table.ApmServicesTable, {
    status: mainStatisticsStatus,
    items: mainStatisticsData.items,
    comparisonDataLoading: comparisonFetch.status === _use_fetcher.FETCH_STATUS.LOADING,
    displayHealthStatus: displayHealthStatus,
    displayAlerts: displayAlerts,
    initialSortField: initialSortField,
    initialSortDirection: initialSortDirection,
    sortFn: sortFn,
    comparisonData: comparisonFetch === null || comparisonFetch === void 0 ? void 0 : comparisonFetch.data,
    noItemsMessage: noItemsMessage,
    initialPageSize: INITIAL_PAGE_SIZE,
    serviceOverflowCount: serviceOverflowCount,
    onChangeSearchQuery: setDebouncedSearchQuery,
    onChangeRenderedItems: setRenderedItems,
    maxCountExceeded: (_mainStatisticsData$m = mainStatisticsData === null || mainStatisticsData === void 0 ? void 0 : mainStatisticsData.maxCountExceeded) !== null && _mainStatisticsData$m !== void 0 ? _mainStatisticsData$m : false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 298,
      columnNumber: 11
    }
  }))));
}