"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProfilingOverview = ProfilingOverview;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/observability-shared-plugin/public");
var _react2 = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _agent_name = require("../../../../common/agent_name");
var _document_type = require("../../../../common/document_type");
var _use_apm_service_context = require("../../../context/apm_service/use_apm_service_context");
var _use_apm_params = require("../../../hooks/use_apm_params");
var _use_preferred_data_source_and_bucket_size = require("../../../hooks/use_preferred_data_source_and_bucket_size");
var _use_profiling_plugin = require("../../../hooks/use_profiling_plugin");
var _use_time_range = require("../../../hooks/use_time_range");
var _url_helpers = require("../../shared/links/url_helpers");
var _flamegraph = require("../../shared/profiling/flamegraph");
var _top_functions = require("../../shared/profiling/top_functions");
var _search_bar = require("../../shared/search_bar/search_bar");
var _profiling_hosts_callout = require("./profiling_hosts_callout");
var _profiling_hosts_flamegraph = require("./profiling_hosts_flamegraph");
var _profiling_hosts_top_functions = require("./profiling_hosts_top_functions");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761044620168364099/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/profiling_overview/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ProfilingOverview() {
  const history = (0, _reactRouterDom.useHistory)();
  const {
    path: {
      serviceName
    },
    query: {
      rangeFrom,
      rangeTo,
      environment,
      kuery
    }
  } = (0, _use_apm_params.useApmParams)('/services/{serviceName}/profiling');
  const {
    isProfilingAvailable,
    isLoading
  } = (0, _use_profiling_plugin.useProfilingPlugin)();
  const {
    start,
    end,
    refreshTimeRange
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const preferred = (0, _use_preferred_data_source_and_bucket_size.usePreferredDataSourceAndBucketSize)({
    start,
    end,
    kuery,
    type: _document_type.ApmDocumentType.TransactionMetric,
    numBuckets: 20
  });
  const {
    agentName,
    transactionType
  } = (0, _use_apm_service_context.useApmServiceContext)();
  const isJavaAgent = (0, _agent_name.isJavaAgentName)(agentName);
  const tabs = (0, _react2.useMemo)(() => {
    return [{
      id: 'flamegraph',
      name: _i18n.i18n.translate('xpack.apm.profiling.tabs.flamegraph', {
        defaultMessage: 'Flamegraph'
      }),
      content: /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 61,
          columnNumber: 13
        }
      }), isJavaAgent ? /*#__PURE__*/_react2.default.createElement(_flamegraph.ProfilingFlamegraph, {
        serviceName: serviceName,
        kuery: kuery,
        rangeFrom: rangeFrom,
        rangeTo: rangeTo,
        environment: environment,
        transactionType: transactionType,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 63,
          columnNumber: 15
        }
      }) : /*#__PURE__*/_react2.default.createElement(_profiling_hosts_flamegraph.ProfilingHostsFlamegraph, {
        serviceName: serviceName,
        start: start,
        end: end,
        environment: environment,
        dataSource: preferred === null || preferred === void 0 ? void 0 : preferred.source,
        kuery: kuery,
        rangeFrom: rangeFrom,
        rangeTo: rangeTo,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 72,
          columnNumber: 15
        }
      }))
    }, {
      id: 'topNFunctions',
      name: _i18n.i18n.translate('xpack.apm.profiling.tabs.topNFunctions', {
        defaultMessage: 'Top 10 Functions'
      }),
      content: /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 93,
          columnNumber: 13
        }
      }), isJavaAgent ? /*#__PURE__*/_react2.default.createElement(_top_functions.ProfilingTopNFunctions, {
        serviceName: serviceName,
        kuery: kuery,
        rangeFrom: rangeFrom,
        rangeTo: rangeTo,
        environment: environment,
        transactionType: transactionType,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 95,
          columnNumber: 15
        }
      }) : /*#__PURE__*/_react2.default.createElement(_profiling_hosts_top_functions.ProfilingHostsTopNFunctions, {
        serviceName: serviceName,
        start: start,
        end: end,
        environment: environment,
        startIndex: 0,
        endIndex: 10,
        dataSource: preferred === null || preferred === void 0 ? void 0 : preferred.source,
        kuery: kuery,
        rangeFrom: rangeFrom,
        rangeTo: rangeTo,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 104,
          columnNumber: 15
        }
      }))
    }];
  }, [end, environment, isJavaAgent, kuery, preferred === null || preferred === void 0 ? void 0 : preferred.source, rangeFrom, rangeTo, serviceName, start, transactionType]);
  if (isLoading) {
    return /*#__PURE__*/_react2.default.createElement("div", {
      css: (0, _react.css)`
          display: flex;
          justify-content: center;
        `,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 136,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiLoadingSpinner, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 142,
        columnNumber: 9
      }
    }));
  }
  if (isProfilingAvailable === false) {
    return /*#__PURE__*/_react2.default.createElement(_public.ProfilingEmptyState, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 148,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, isJavaAgent ? /*#__PURE__*/_react2.default.createElement(_search_bar.SearchBar, {
    showTransactionTypeSelector: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 9
    }
  }) : /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_profiling_hosts_callout.ProfilingHostsCallout, {
    serviceName: serviceName,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react2.default.createElement(_public.EmbeddableProfilingSearchBar, {
    kuery: kuery,
    rangeFrom: rangeFrom,
    rangeTo: rangeTo,
    onQuerySubmit: next => {
      (0, _url_helpers.push)(history, {
        query: {
          kuery: next.query,
          rangeFrom: next.dateRange.from,
          rangeTo: next.dateRange.to
        }
      });
    },
    onRefresh: refreshTimeRange,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiTabbedContent, {
    tabs: tabs,
    initialSelectedTab: tabs[0],
    autoFocus: "selected",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 7
    }
  }));
}