"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InstructionsSet = InstructionsSet;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _react2 = require("@emotion/react");
var _instruction_variants = require("./instruction_variants");
var _use_apm_params = require("../../../hooks/use_apm_params");
var _url_helpers = require("../../shared/links/url_helpers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761044620168364099/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/onboarding/instructions_set.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function getTabs(variants) {
  return variants.map(variant => ({
    id: variant.id,
    text: (0, _instruction_variants.getDisplayText)(variant.id)
  }));
}
function InstructionTabs({
  agentTabs,
  selectedTab
}) {
  const history = (0, _reactRouterDom.useHistory)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const onSelectedTabChange = agent => {
    (0, _url_helpers.push)(history, {
      query: {
        agent
      }
    });
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
    css: (0, _react2.css)`
        padding: 0 ${euiTheme.size.l};
      `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 5
    }
  }, agentTabs.map(tab => /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    key: tab.id,
    isSelected: tab.id === selectedTab,
    onClick: () => onSelectedTabChange(tab.id),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 9
    }
  }, tab.text)));
}
function InstructionSteps({
  instructions,
  selectedTab
}) {
  const selectInstructionSteps = instructions.find(variant => {
    return variant.id === selectedTab;
  });
  if (!selectInstructionSteps) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, selectInstructionSteps.title && /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 11
    }
  }, selectInstructionSteps.title)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSteps, {
    titleSize: "xs",
    steps: selectInstructionSteps.instructions,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 7
    }
  }));
}
function InstructionsSet({
  instructions
}) {
  const tabs = (0, _react.useMemo)(() => getTabs(instructions), [instructions]);
  const {
    query: {
      agent: agentQuery
    }
  } = (0, _use_apm_params.useApmParams)('/onboarding');
  const selectedTab = agentQuery !== null && agentQuery !== void 0 ? agentQuery : tabs[0].id;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Outer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    color: "subdued",
    paddingSize: "none",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(InstructionTabs, {
    agentTabs: tabs,
    selectedTab: selectedTab,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    paddingSize: "l",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(InstructionSteps, {
    instructions: instructions,
    selectedTab: selectedTab,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 9
    }
  })));
}