"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DependencyDetailOverview = DependencyDetailOverview;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _use_breadcrumb = require("../../../context/breadcrumbs/use_breadcrumb");
var _chart_pointer_event_context = require("../../../context/chart_pointer_event/chart_pointer_event_context");
var _use_apm_params = require("../../../hooks/use_apm_params");
var _use_apm_router = require("../../../hooks/use_apm_router");
var _dependencies_detail_table = require("./dependencies_detail_table");
var _dependency_metric_charts = require("../../shared/dependency_metric_charts");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761044620168364099/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/dependency_detail_overview/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function DependencyDetailOverview() {
  const {
    query: {
      dependencyName,
      rangeFrom,
      rangeTo,
      refreshInterval,
      refreshPaused,
      environment,
      kuery,
      comparisonEnabled
    }
  } = (0, _use_apm_params.useApmParams)('/dependencies/overview');
  const apmRouter = (0, _use_apm_router.useApmRouter)();
  (0, _use_breadcrumb.useBreadcrumb)(() => [{
    title: _i18n.i18n.translate('xpack.apm.dependencyDetailOverview.breadcrumbTitle', {
      defaultMessage: 'Overview'
    }),
    href: apmRouter.link('/dependencies/overview', {
      query: {
        dependencyName,
        rangeFrom,
        rangeTo,
        refreshInterval,
        refreshPaused,
        environment,
        kuery,
        comparisonEnabled
      }
    })
  }], [apmRouter, comparisonEnabled, dependencyName, environment, kuery, rangeFrom, rangeTo, refreshInterval, refreshPaused]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_chart_pointer_event_context.ChartPointerEventContextProvider, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_dependency_metric_charts.DependencyMetricCharts, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_dependencies_detail_table.DependenciesDetailTable, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 7
    }
  }));
}