"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.callAsyncWithDebug = callAsyncWithDebug;
var _common = require("@kbn/inspector-plugin/common");
var _common2 = require("@kbn/observability-shared-plugin/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function callAsyncWithDebug({
  cb,
  debug,
  request,
  requestParams,
  operationName,
  isCalledWithInternalUser,
  inspectableEsQueriesMap = new WeakMap()
}) {
  if (!debug) {
    return cb();
  }
  let res;
  let esError = null;
  let esRequestStatus = _common.RequestStatus.PENDING;
  const startTimeNow = Date.now();
  try {
    res = await cb();
    esRequestStatus = _common.RequestStatus.OK;
  } catch (e) {
    // catch error and throw after outputting debug info
    esError = e;
    esRequestStatus = _common.RequestStatus.ERROR;
  }
  if (request) {
    const inspectableEsQueries = inspectableEsQueriesMap.get(request);
    if (!isCalledWithInternalUser && inspectableEsQueries) {
      inspectableEsQueries.push((0, _common2.getInspectResponse)({
        esError,
        esRequestParams: requestParams,
        esRequestStatus,
        esResponse: res,
        kibanaRequest: request,
        operationName,
        startTime: startTimeNow
      }));
    }
  }
  if (esError) {
    throw esError;
  }
  return res;
}