"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.untrackRuleAlerts = void 0;
var _lodash = require("lodash");
var _server = require("@kbn/event-log-plugin/server");
var _apmUtils = require("@kbn/apm-utils");
var _alert_task_instance = require("../../task_runner/alert_task_instance");
var _alert = require("../../alert");
var _plugin = require("../../plugin");
var _create_alert_event_log_record_object = require("../../lib/create_alert_event_log_record_object");
var _saved_objects = require("../../saved_objects");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const untrackRuleAlerts = async (context, id, attributes) => {
  return (0, _apmUtils.withSpan)({
    name: 'untrackRuleAlerts',
    type: 'rules'
  }, async () => {
    if (!context.eventLogger || !attributes.scheduledTaskId) return;
    try {
      var _state$alertInstances;
      const taskInstance = (0, _alert_task_instance.taskInstanceToAlertTaskInstance)(await context.taskManager.get(attributes.scheduledTaskId), attributes);
      const {
        state
      } = taskInstance;
      const untrackedAlerts = (0, _lodash.mapValues)((_state$alertInstances = state.alertInstances) !== null && _state$alertInstances !== void 0 ? _state$alertInstances : {}, (rawAlertInstance, alertId) => new _alert.Alert(alertId, rawAlertInstance));
      const untrackedAlertIds = Object.keys(untrackedAlerts);
      const ruleType = context.ruleTypeRegistry.get(attributes.alertTypeId);
      const {
        autoRecoverAlerts: isLifecycleAlert
      } = ruleType;

      // Untrack Stack alerts
      // TODO: Replace this loop with an Alerts As Data implmentation when Stack Rules use Alerts As Data
      // instead of the Kibana Event Log
      for (const alertId of untrackedAlertIds) {
        var _untrackedAlerts$aler;
        const {
          group: actionGroup
        } = (_untrackedAlerts$aler = untrackedAlerts[alertId].getLastScheduledActions()) !== null && _untrackedAlerts$aler !== void 0 ? _untrackedAlerts$aler : {};
        const instanceState = untrackedAlerts[alertId].getState();
        const message = `instance '${alertId}' has been untracked because the rule was disabled`;
        const alertUuid = untrackedAlerts[alertId].getUuid();
        const event = (0, _create_alert_event_log_record_object.createAlertEventLogRecordObject)({
          ruleId: id,
          ruleName: attributes.name,
          ruleRevision: attributes.revision,
          ruleType,
          consumer: attributes.consumer,
          instanceId: alertId,
          alertUuid,
          action: _plugin.EVENT_LOG_ACTIONS.untrackedInstance,
          message,
          state: instanceState,
          group: actionGroup,
          namespace: context.namespace,
          spaceId: context.spaceId,
          savedObjects: [{
            id,
            type: _saved_objects.RULE_SAVED_OBJECT_TYPE,
            typeId: attributes.alertTypeId,
            relation: _server.SAVED_OBJECT_REL_PRIMARY
          }]
        });
        context.eventLogger.logEvent(event);
      }

      // Untrack Lifecycle alerts (Alerts As Data-enabled)
      if (isLifecycleAlert) {
        const indices = context.getAlertIndicesAlias([ruleType.id], context.spaceId);
        if (!context.alertsService) throw new Error('Could not access alertsService to untrack alerts');
        await context.alertsService.setAlertsToUntracked({
          indices,
          ruleIds: [id]
        });
      }
    } catch (error) {
      // this should not block the rest of the disable process
      context.logger.warn(`rulesClient.disableRule('${id}') - Could not write untrack events - ${error.message}`);
    }
  });
};
exports.untrackRuleAlerts = untrackRuleAlerts;