"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogCategorizationPage = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _mlUrlState = require("@kbn/ml-url-state");
var _constants = require("@kbn/aiops-common/constants");
var _use_table_state = require("@kbn/ml-in-memory-table/hooks/use_table_state");
var _use_data_source = require("../../hooks/use_data_source");
var _use_data = require("../../hooks/use_data");
var _use_search = require("../../hooks/use_search");
var _use_aiops_app_context = require("../../hooks/use_aiops_app_context");
var _log_pattern_analysis = require("../../application/url_state/log_pattern_analysis");
var _search_panel = require("../search_panel");
var _page_header = require("../page_header");
var _use_categorize_request = require("./use_categorize_request");
var _category_table = require("./category_table");
var _document_count_chart = require("./document_count_chart");
var _information_text = require("./information_text");
var _sampling_menu = require("./sampling_menu");
var _use_validate_category_field = require("./use_validate_category_field");
var _category_validation_callout = require("./category_validation_callout");
var _utils = require("./utils");
var _table_header = require("./category_table/table_header");
var _use_actions = require("./category_table/use_actions");
var _attachments_menu = require("./attachments_menu");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761044620168364099/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/aiops/public/components/log_categorization/log_categorization_page.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const BAR_TARGET = 20;
const DEFAULT_SELECTED_FIELD = 'message';
const LogCategorizationPage = () => {
  var _data$categories$leng, _data$categories;
  const {
    notifications: {
      toasts
    },
    embeddingOrigin
  } = (0, _use_aiops_app_context.useAiopsAppContext)();
  const {
    dataView,
    savedSearch
  } = (0, _use_data_source.useDataSource)();
  const randomSamplerStorage = (0, _sampling_menu.useRandomSamplerStorage)();
  const {
    runCategorizeRequest,
    cancelRequest: cancelCategorizationRequest,
    randomSampler
  } = (0, _use_categorize_request.useCategorizeRequest)(randomSamplerStorage);
  const {
    runValidateFieldRequest,
    cancelRequest: cancelValidationRequest
  } = (0, _use_validate_category_field.useValidateFieldRequest)();
  const [stateFromUrl, setUrlState] = (0, _mlUrlState.usePageUrlState)('logCategorization', (0, _log_pattern_analysis.getDefaultLogCategorizationAppState)());
  const [globalState, setGlobalState] = (0, _mlUrlState.useUrlState)('_g');
  const [selectedField, setSelectedField] = (0, _react.useState)();
  const [highlightedCategory, setHighlightedCategory] = (0, _react.useState)(null);
  const [selectedCategories, setSelectedCategories] = (0, _react.useState)([]);
  const [selectedSavedSearch, setSelectedSavedSearch] = (0, _react.useState)(savedSearch);
  const [previousDocumentStatsHash, setPreviousDocumentStatsHash] = (0, _react.useState)(0);
  const [loading, setLoading] = (0, _react.useState)(false);
  const [totalCount, setTotalCount] = (0, _react.useState)(0);
  const [eventRate, setEventRate] = (0, _react.useState)([]);
  const [pinnedCategory, setPinnedCategory] = (0, _react.useState)(null);
  const [data, setData] = (0, _react.useState)(null);
  const [fieldValidationResult, setFieldValidationResult] = (0, _react.useState)(null);
  const tableState = (0, _use_table_state.useTableState)([], 'key');
  const cancelRequest = (0, _react.useCallback)(() => {
    cancelValidationRequest();
    cancelCategorizationRequest();
  }, [cancelCategorizationRequest, cancelValidationRequest]);
  (0, _react.useEffect)(() => {
    if (savedSearch) {
      setSelectedSavedSearch(savedSearch);
    }
  }, [savedSearch]);
  (0, _react.useEffect)(function cancelRequestOnLeave() {
    return () => {
      cancelRequest();
    };
  }, [cancelRequest]);
  const setSearchParams = (0, _react.useCallback)(searchParams => {
    // When the user loads saved search and then clear or modify the query
    // we should remove the saved search and replace it with the index pattern id
    if (selectedSavedSearch !== null) {
      setSelectedSavedSearch(null);
    }
    setUrlState({
      ...stateFromUrl,
      searchQuery: searchParams.searchQuery,
      searchString: searchParams.searchString,
      searchQueryLanguage: searchParams.queryLanguage,
      filters: searchParams.filters
    });
  }, [selectedSavedSearch, stateFromUrl, setUrlState]);
  const {
    searchQueryLanguage,
    searchString,
    searchQuery
  } = (0, _use_search.useSearch)({
    dataView,
    savedSearch: selectedSavedSearch
  }, stateFromUrl);
  const {
    documentStats,
    timefilter,
    earliest,
    latest,
    intervalMs
  } = (0, _use_data.useData)(dataView, 'log_categorization', searchQuery, setGlobalState, undefined, undefined, BAR_TARGET);
  const {
    getActions,
    openInDiscover
  } = (0, _use_actions.useActions)(dataView.id, selectedField, selectedCategories, stateFromUrl, timefilter, undefined, undefined);
  (0, _react.useEffect)(() => {
    if ((globalState === null || globalState === void 0 ? void 0 : globalState.time) !== undefined) {
      timefilter.setTime({
        from: globalState.time.from,
        to: globalState.time.to
      });
    }
  }, [globalState === null || globalState === void 0 ? void 0 : globalState.time, timefilter]);
  const fields = (0, _react.useMemo)(() => dataView.fields.filter(({
    displayName,
    esTypes
  }) => esTypes && esTypes.includes('text') && !['_id', '_index'].includes(displayName)).map(({
    displayName
  }) => ({
    label: displayName
  })), [dataView]);
  const loadCategories = (0, _react.useCallback)(async () => {
    setLoading(true);
    setData(null);
    setFieldValidationResult(null);
    const {
      getIndexPattern,
      timeFieldName: timeField
    } = dataView;
    const index = getIndexPattern();
    if (selectedField === undefined || timeField === undefined || earliest === undefined || latest === undefined) {
      setLoading(false);
      return;
    }
    cancelRequest();
    const timeRange = {
      from: earliest,
      to: latest
    };
    const runtimeMappings = dataView.getRuntimeMappings();
    try {
      const [validationResult, categorizationResult] = await Promise.all([runValidateFieldRequest(index, selectedField, timeField, timeRange, searchQuery, runtimeMappings, {
        [_constants.AIOPS_ANALYSIS_RUN_ORIGIN]: embeddingOrigin
      }), runCategorizeRequest(index, selectedField, timeField, timeRange, searchQuery, runtimeMappings, intervalMs)]);
      setFieldValidationResult(validationResult);
      setData({
        categories: categorizationResult.categories,
        displayExamples: categorizationResult.hasExamples
      });
    } catch (error) {
      toasts.addError(error, {
        title: _i18n.i18n.translate('xpack.aiops.logCategorization.errorLoadingCategories', {
          defaultMessage: 'Error loading categories'
        })
      });
    }
    setLoading(false);
  }, [dataView, selectedField, cancelRequest, runValidateFieldRequest, earliest, latest, searchQuery, runCategorizeRequest, intervalMs, toasts, embeddingOrigin]);
  (0, _react.useEffect)(() => {
    var _documentStats$docume;
    const buckets = (_documentStats$docume = documentStats.documentCountStats) === null || _documentStats$docume === void 0 ? void 0 : _documentStats$docume.buckets;
    if (buckets === undefined) {
      return;
    }
    const hash = (0, _utils.createDocumentStatsHash)(documentStats);
    if (hash !== previousDocumentStatsHash) {
      randomSampler.setDocCount(documentStats.totalCount);
      setEventRate(Object.entries(buckets).map(([key, docCount]) => ({
        key: +key,
        docCount
      })));
      setTotalCount(documentStats.totalCount);
      if (fieldValidationResult !== null) {
        loadCategories();
      }
    }
    setPreviousDocumentStatsHash(hash);
  }, [documentStats, earliest, latest, searchQueryLanguage, searchString, searchQuery, randomSampler, totalCount, previousDocumentStatsHash, fieldValidationResult, loadCategories]);
  (0, _react.useEffect)(function autoSelectField() {
    if (selectedField !== undefined) {
      return;
    }
    const field = stateFromUrl.field;
    if (field !== undefined && fields.find(f => f.label === field)) {
      // select field from URL, if it exists
      setSelectedField(field);
    } else if (fields.length === 1) {
      // otherwise, if there is only one field in the list, select it
      setSelectedField(fields[0].label);
    } else if (fields.find(f => f.label === DEFAULT_SELECTED_FIELD)) {
      // otherwise, if there is a field called `message`, select it
      setSelectedField(DEFAULT_SELECTED_FIELD);
    }
  }, [fields, loadCategories, selectedField, stateFromUrl.field]);
  const onFieldChange = value => {
    setData(null);
    setFieldValidationResult(null);
    const field = value && value.length ? value[0].label : undefined;
    setSelectedField(field);
    setUrlState({
      field
    });
  };
  const actions = getActions(true);
  const attachmentsMenuProps = {
    dataView,
    selectedField,
    randomSamplerMode: randomSampler.getMode(),
    randomSamplerProbability: randomSampler.getProbability()
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, {
    "data-test-subj": "aiopsLogPatternAnalysisPage",
    paddingSize: "none",
    panelled: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 346,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_page_header.PageHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 347,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 348,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 349,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 350,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_search_panel.SearchPanel, {
    searchString: searchString !== null && searchString !== void 0 ? searchString : '',
    searchQuery: searchQuery,
    searchQueryLanguage: searchQueryLanguage,
    setSearchParams: setSearchParams,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 351,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 359,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 360,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 361,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: {
      minWidth: '400px'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 362,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.aiops.logCategorization.categoryFieldSelect', {
      defaultMessage: 'Category field'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 363,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    isDisabled: loading === true,
    options: fields,
    onChange: onFieldChange,
    selectedOptions: selectedField === undefined ? undefined : [{
      label: selectedField
    }],
    singleSelection: {
      asPlainText: true
    },
    "data-test-subj": "aiopsLogPatternAnalysisCategoryField",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 368,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: {
      marginTop: 'auto'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 380,
      columnNumber: 11
    }
  }, loading === false ? /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    disabled: selectedField === undefined,
    onClick: () => {
      loadCategories();
    },
    "data-test-subj": "aiopsLogPatternAnalysisRunButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 382,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.aiops.logCategorization.runButton",
    defaultMessage: "Run pattern analysis",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 389,
      columnNumber: 17
    }
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "aiopsLogCategorizationPageCancelButton",
    onClick: () => cancelRequest(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 395,
      columnNumber: 15
    }
  }, "Cancel"))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    css: {
      marginTop: 'auto'
    },
    alignItems: "center",
    justifyContent: "flexEnd",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 404,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 410,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_sampling_menu.SamplingMenu, {
    randomSampler: randomSampler,
    reload: () => loadCategories(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 411,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 413,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_attachments_menu.AttachmentsMenu, (0, _extends2.default)({}, attachmentsMenuProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 414,
      columnNumber: 13
    }
  }))))), eventRate.length ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 421,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_document_count_chart.DocumentCountChart, {
    eventRate: eventRate,
    pinnedCategory: pinnedCategory,
    selectedCategory: highlightedCategory,
    totalCount: totalCount,
    documentCountStats: documentStats.documentCountStats,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 422,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 429,
      columnNumber: 11
    }
  })) : null, /*#__PURE__*/_react.default.createElement(_category_validation_callout.FieldValidationCallout, {
    validationResults: fieldValidationResult,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 433,
      columnNumber: 7
    }
  }), loading === true ? /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    lines: 10,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 435,
      columnNumber: 27
    }
  }) : null, /*#__PURE__*/_react.default.createElement(_information_text.InformationText, {
    loading: loading,
    categoriesLength: (_data$categories$leng = data === null || data === void 0 ? void 0 : (_data$categories = data.categories) === null || _data$categories === void 0 ? void 0 : _data$categories.length) !== null && _data$categories$leng !== void 0 ? _data$categories$leng : null,
    eventRateLength: eventRate.length,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 437,
      columnNumber: 7
    }
  }), selectedField !== undefined && data !== null && data.categories.length > 0 ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_table_header.TableHeader, {
    categoriesCount: data.categories.length,
    selectedCategoriesCount: selectedCategories.length,
    openInDiscover: openInDiscover,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 445,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 451,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 452,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_category_table.CategoryTable, {
    categories: data.categories,
    eventRate: eventRate,
    mouseOver: {
      pinnedCategory,
      setPinnedCategory,
      highlightedCategory,
      setHighlightedCategory
    },
    displayExamples: data.displayExamples,
    setSelectedCategories: setSelectedCategories,
    tableState: tableState,
    actions: actions,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 454,
      columnNumber: 11
    }
  })) : null);
};
exports.LogCategorizationPage = LogCategorizationPage;