"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.assertMetadataFromTypescriptIfManaged = assertMetadataFromTypescriptIfManaged;
const InversifyCoreError_1 = require("../../error/models/InversifyCoreError");
const InversifyCoreErrorKind_1 = require("../../error/models/InversifyCoreErrorKind");
const MaybeClassElementMetadataKind_1 = require("../models/MaybeClassElementMetadataKind");
function assertMetadataFromTypescriptIfManaged(metadata) {
    if (metadata.kind !== MaybeClassElementMetadataKind_1.MaybeClassElementMetadataKind.unknown &&
        metadata.isFromTypescriptParamType !== true) {
        throw new InversifyCoreError_1.InversifyCoreError(InversifyCoreErrorKind_1.InversifyCoreErrorKind.injectionDecoratorConflict, 'Unexpected injection found. Multiple @inject, @multiInject or @unmanaged decorators found');
    }
}
//# sourceMappingURL=assertMetadataFromTypescriptIfManaged.js.map