"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.decorate = decorate;
function decorate(decorators, target, parameterIndexOrProperty, parameterIndex) {
    const parsedDecorators = Array.isArray(decorators)
        ? decorators
        : [decorators];
    if (parameterIndexOrProperty === undefined) {
        // Asume ClassDecorator[]
        Reflect.decorate(parsedDecorators, target);
        return;
    }
    if (typeof parameterIndexOrProperty === 'number') {
        // Asume ParameterDecorator[]
        for (const decorator of parsedDecorators) {
            decorator(target, undefined, parameterIndexOrProperty);
        }
        return;
    }
    if (parameterIndex === undefined) {
        Reflect.decorate(parsedDecorators, target.prototype, parameterIndexOrProperty);
        return;
    }
    for (const decorator of parsedDecorators) {
        decorator(target, parameterIndexOrProperty, parameterIndex);
    }
}
//# sourceMappingURL=decorate.js.map