"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ColorLabel = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ColorLabel = ({
  label,
  color,
  paletteSelected
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "stopFilled",
    color: color,
    size: "xl",
    "aria-label": _i18n.i18n.translate('xpack.infra.legendControls.iconColorLabel', {
      defaultMessage: '{label} {paletteSelected} color',
      values: {
        label,
        paletteSelected
      }
    })
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("strong", null, label))));
};
exports.ColorLabel = ColorLabel;