"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PageViewLogInContext = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _common = require("@kbn/logs-shared-plugin/common");
var _useAsync = _interopRequireDefault(require("react-use/lib/useAsync"));
var _savedSearchComponent = require("@kbn/saved-search-component");
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _use_kibana = require("../../../hooks/use_kibana");
var _use_date_picker = require("../../../components/asset_details/hooks/use_date_picker");
var _view_log_in_context = require("../../../containers/logs/view_log_in_context");
var _use_viewport_dimensions = require("../../../hooks/use_viewport_dimensions");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MODAL_MARGIN = 25;
const PageViewLogInContext = () => {
  const {
    services: {
      logsDataAccess: {
        services: {
          logSourcesService
        }
      },
      embeddable,
      dataViews,
      data: {
        search: {
          searchSource
        }
      },
      share: {
        url
      }
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const {
    dateRange
  } = (0, _use_date_picker.useDatePickerContext)();
  const logsLocator = (0, _common.getLogsLocatorFromUrlService)(url);
  const logSources = (0, _useAsync.default)(logSourcesService.getFlattenedLogSources);
  const [{
    contextEntry
  }, {
    setContextEntry
  }] = (0, _view_log_in_context.useViewLogInProviderContext)();
  const closeModal = (0, _react.useCallback)(() => setContextEntry(undefined), [setContextEntry]);
  const {
    width: vw,
    height: vh
  } = (0, _use_viewport_dimensions.useViewportDimensions)();
  const contextQuery = (0, _react.useMemo)(() => {
    if (contextEntry && !(0, _lodash.isEmpty)(contextEntry.context)) {
      return {
        language: 'kuery',
        query: Object.entries(contextEntry.context).reduce((kuery, [key, value]) => {
          const currentExpression = `${key} : "${value}"`;
          if (kuery.length > 0) {
            return `${kuery} AND ${currentExpression}`;
          } else {
            return currentExpression;
          }
        }, '')
      };
    }
  }, [contextEntry]);
  if (!contextEntry) {
    return null;
  }
  const discoverLink = logsLocator === null || logsLocator === void 0 ? void 0 : logsLocator.getRedirectUrl({
    timeRange: dateRange,
    query: contextQuery
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_react2.Global, {
    styles: (0, _react2.css)`
          .DiscoverFlyout {
            z-index: 6000 !important;
          }
        `
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    onClose: closeModal,
    maxWidth: false
  }, /*#__PURE__*/_react.default.createElement(LogInContextWrapper, {
    width: vw - MODAL_MARGIN * 2,
    height: vh - MODAL_MARGIN * 2
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    responsive: false,
    wrap: false,
    css: {
      height: '100%'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(LogEntryContext, {
    context: contextEntry.context,
    discoverLink: discoverLink
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, logSources.value ? /*#__PURE__*/_react.default.createElement(_savedSearchComponent.LazySavedSearchComponent, {
    dependencies: {
      embeddable,
      searchSource,
      dataViews
    },
    index: logSources.value,
    timeRange: dateRange,
    query: contextQuery,
    height: '100%',
    displayOptions: {
      solutionNavIdOverride: 'oblt',
      enableFilters: false
    }
  }) : null)))));
};
exports.PageViewLogInContext = PageViewLogInContext;
const LogInContextWrapper = _styled.default.div`
  padding: 16px;
  width: ${props => typeof props.width === 'number' ? `${props.width}px` : props.width};
  height: ${props => typeof props.height === 'number' ? `${props.height}px` : props.height};
  max-height: 75vh; // Same as EuiModal
`;
const LogEntryContext = ({
  context,
  discoverLink
}) => {
  let text;
  if ('container.id' in context) {
    text = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.logs.viewInContext.logsFromContainerTitle",
      defaultMessage: "Displayed logs are from container {container}",
      values: {
        container: context['container.id']
      }
    });
  }
  if ('host.name' in context) {
    const shortenedFilePath = context['log.file.path'].length > 45 ? context['log.file.path'].slice(0, 20) + '...' + context['log.file.path'].slice(-25) : context['log.file.path'];
    text = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.logs.viewInContext.logsFromFileTitle",
      defaultMessage: "Displayed logs are from file {file} and host {host}",
      values: {
        file: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
          content: context['log.file.path']
        }, /*#__PURE__*/_react.default.createElement("span", null, shortenedFilePath)),
        host: context['host.name']
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("p", {
    style: {
      margin: 0
    }
  }, text))), discoverLink && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "infraHostLogsTabOpenInDiscoverLink",
    href: discoverLink,
    target: "_blank",
    color: "primary",
    external: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "xs",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "discoverApp",
    size: "s",
    color: "primary"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, _i18n.i18n.translate('xpack.infra.logs.viewInContext.openInDiscoverLabel', {
    defaultMessage: 'Open in Discover'
  })))))));
};