"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useIlmLocator = void 0;
var _public = require("@kbn/share-plugin/public");
var _app_context = require("../app_context");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useIlmLocator = (page, policyName) => {
  const ctx = (0, _app_context.useAppContext)();
  const locator = policyName === undefined ? null : ctx.url.locators.get(_constants.ILM_LOCATOR_ID);
  const url = (0, _public.useLocatorUrl)(locator, {
    page,
    policyName
  }, {}, [page, policyName]);
  return url;
};
exports.useIlmLocator = useIlmLocator;