"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TabSummary = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _app_context = require("../../../../../app_context");
var _lib = require("../../../../../../../common/lib");
var _data_streams = require("../../../../../lib/data_streams");
var _constants = require("../../../../../constants");
var _use_ilm_locator = require("../../../../../services/use_ilm_locator");
var _use_ingest_pipeline_locator = require("../../../../../services/use_ingest_pipeline_locator");
var _constants2 = require("../../../../../../../common/constants");
var _index_mode_labels = require("../../../../../lib/index_mode_labels");
var _ = require("../../../../../..");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const INFINITE_AS_ICON = true;
const i18nTexts = {
  yes: _i18n.i18n.translate('xpack.idxMgmt.templateDetails.summaryTab.yesDescriptionText', {
    defaultMessage: 'Yes'
  }),
  no: _i18n.i18n.translate('xpack.idxMgmt.templateDetails.summaryTab.noDescriptionText', {
    defaultMessage: 'No'
  }),
  none: _i18n.i18n.translate('xpack.idxMgmt.templateDetails.summaryTab.noneDescriptionText', {
    defaultMessage: 'None'
  })
};
const TabSummary = ({
  templateDetails
}) => {
  var _templateDetails$temp, _templateDetails$temp2, _templateDetails$temp3;
  const {
    version,
    priority,
    composedOf,
    order,
    indexPatterns = [],
    indexMode,
    ilmPolicy,
    _meta,
    _kbnMeta: {
      isLegacy,
      hasDatastream
    },
    allowAutoCreate
  } = templateDetails;
  const numIndexPatterns = indexPatterns.length;
  const {
    core,
    url
  } = (0, _app_context.useAppContext)();
  const ilmPolicyLink = (0, _use_ilm_locator.useIlmLocator)(_constants.ILM_PAGES_POLICY_EDIT, ilmPolicy === null || ilmPolicy === void 0 ? void 0 : ilmPolicy.name);
  const locator = url.locators.get(_.INDEX_MANAGEMENT_LOCATOR_ID);

  // Compute the linked ingest pipeline URL
  const linkedIngestPipeline = templateDetails === null || templateDetails === void 0 ? void 0 : (_templateDetails$temp = templateDetails.template) === null || _templateDetails$temp === void 0 ? void 0 : (_templateDetails$temp2 = _templateDetails$temp.settings) === null || _templateDetails$temp2 === void 0 ? void 0 : (_templateDetails$temp3 = _templateDetails$temp2.index) === null || _templateDetails$temp3 === void 0 ? void 0 : _templateDetails$temp3.default_pipeline;
  const linkedIngestPipelineUrl = (0, _use_ingest_pipeline_locator.useIngestPipelinesLocator)(_constants.INGEST_PIPELINES_EDIT, linkedIngestPipeline);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": "summaryTab"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    textStyle: "reverse"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.templateDetails.summaryTab.indexPatternsDescriptionListTitle",
    defaultMessage: "Index {numIndexPatterns, plural, one {pattern} other {patterns}}",
    values: {
      numIndexPatterns
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, numIndexPatterns > 1 ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("ul", null, indexPatterns.map((indexName, i) => {
    return /*#__PURE__*/_react.default.createElement("li", {
      key: `${indexName}-${i}`
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("span", null, indexName)));
  }))) : indexPatterns.toString()), isLegacy !== true ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.templateDetails.summaryTab.priorityDescriptionListTitle",
    defaultMessage: "Priority"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, priority || priority === 0 ? priority : i18nTexts.none)) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.templateDetails.summaryTab.orderDescriptionListTitle",
    defaultMessage: "Order"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, order || order === 0 ? order : i18nTexts.none)), isLegacy !== true && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    "data-test-subj": "componentsTitle"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.templateDetails.summaryTab.componentsDescriptionListTitle",
    defaultMessage: "Component templates"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, composedOf && composedOf.length > 0 ? /*#__PURE__*/_react.default.createElement("ul", null, composedOf.map(component => /*#__PURE__*/_react.default.createElement("li", {
    key: component
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: (locator === null || locator === void 0 ? void 0 : locator.getRedirectUrl({
      page: 'component_template',
      componentTemplate: component
    })) || ''
  }, /*#__PURE__*/_react.default.createElement("span", null, component))))) : i18nTexts.none)), linkedIngestPipeline && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.templateDetails.summaryTab.linkedIngestPipelineDescriptionListTitle",
    defaultMessage: "Default pipeline"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: () => core.application.navigateToUrl(linkedIngestPipelineUrl),
    "data-test-subj": "linkedIngestPipeline"
  }, linkedIngestPipeline))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    textStyle: "reverse"
  }, isLegacy && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.templateDetails.summaryTab.ilmPolicyDescriptionListTitle",
    defaultMessage: "ILM policy"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, ilmPolicy !== null && ilmPolicy !== void 0 && ilmPolicy.name && ilmPolicyLink ? /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: () => core.application.navigateToUrl(ilmPolicyLink)
  }, ilmPolicy.name) : (ilmPolicy === null || ilmPolicy === void 0 ? void 0 : ilmPolicy.name) || i18nTexts.none)), isLegacy !== true && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.templateDetails.summaryTab.dataStreamDescriptionListTitle",
    defaultMessage: "Data stream"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, hasDatastream ? i18nTexts.yes : i18nTexts.no)), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.templateDetails.summaryTab.versionDescriptionListTitle",
    defaultMessage: "Version"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, version || version === 0 ? version : i18nTexts.none), hasDatastream && (templateDetails === null || templateDetails === void 0 ? void 0 : templateDetails.lifecycle) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.templateDetails.summaryTab.lifecycleDescriptionListTitle",
    defaultMessage: "Data retention"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, (0, _data_streams.getLifecycleValue)((0, _lib.serializeAsESLifecycle)(templateDetails.lifecycle), INFINITE_AS_ICON))), indexMode && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.templateDetails.stepReview.summaryTab.indexModeLabel",
    defaultMessage: "Index mode"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    "data-test-subj": "indexModeValue"
  }, _index_mode_labels.indexModeLabels[indexMode])), isLegacy !== true && allowAutoCreate !== _constants2.allowAutoCreateRadioIds.NO_OVERWRITE_RADIO_OPTION && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.templateDetails.summaryTab.allowAutoCreateDescriptionListTitle",
    defaultMessage: "Allow auto create"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, allowAutoCreate === _constants2.allowAutoCreateRadioIds.TRUE_RADIO_OPTION ? i18nTexts.yes : i18nTexts.no))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    textStyle: "reverse"
  }, isLegacy !== true && _meta && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    "data-test-subj": "metaTitle"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.templateDetails.summaryTab.metaDescriptionListTitle",
    defaultMessage: "Metadata"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "json"
  }, JSON.stringify(_meta, null, 2))))));
};
exports.TabSummary = TabSummary;