"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexErrorCallout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const IndexErrorCallout = ({
  errors
}) => {
  const [showErrors, setShowErrors] = (0, _react.useState)(false);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    "data-test-subj": "indexErrorCallout",
    color: "danger",
    iconType: "error",
    title: _i18n.i18n.translate('xpack.idxMgmt.indexOverview.indexErrors.title', {
      defaultMessage: 'Index has errors'
    })
  }, showErrors && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.idxMgmt.indexOverview.indexErrors.body', {
    defaultMessage: 'Found errors in the following fields:'
  }), errors.map(({
    field,
    error
  }) => /*#__PURE__*/_react.default.createElement("li", {
    key: field.path.join('.')
  }, /*#__PURE__*/_react.default.createElement("strong", null, field.path.join('.')), ": ", error))), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "danger",
    onClick: () => setShowErrors(false)
  }, _i18n.i18n.translate('xpack.idxMgmt.indexOverview.indexErrors.hideErrorsLabel', {
    defaultMessage: 'Hide full error'
  }))), !showErrors && /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "danger",
    onClick: () => setShowErrors(true)
  }, _i18n.i18n.translate('xpack.idxMgmt.indexOverview.indexErrors.showErrorsLabel', {
    defaultMessage: 'Show full error'
  })));
};
exports.IndexErrorCallout = IndexErrorCallout;