"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuntimeFieldsListItem = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _lib = require("../../lib");
var _delete_field_provider = require("./delete_field_provider");
var _listItemStyle = require("../document_fields/common/listItemStyle");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function RuntimeFieldsListItemComponent({
  field,
  areActionButtonsVisible,
  isHighlighted,
  isDimmed,
  editField
}, ref) {
  const {
    source
  } = field;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const styles = (0, _listItemStyle.getListItemStyle)(euiTheme);
  const renderActionButtons = () => {
    if (!areActionButtonsVisible) {
      return null;
    }
    const editButtonLabel = _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.editRuntimeFieldButtonLabel', {
      defaultMessage: 'Edit'
    });
    const deleteButtonLabel = _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.removeRuntimeFieldButtonLabel', {
      defaultMessage: 'Remove'
    });
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      css: styles.actions
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: editButtonLabel,
      disableScreenReaderOutput: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      iconType: "pencil",
      onClick: editField,
      "data-test-subj": "editFieldButton",
      "aria-label": editButtonLabel
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_delete_field_provider.DeleteRuntimeFieldProvider, null, deleteField => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: deleteButtonLabel,
      disableScreenReaderOutput: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      iconType: "trash",
      color: "danger",
      onClick: () => deleteField(field),
      "data-test-subj": "removeFieldButton",
      "aria-label": deleteButtonLabel
    })))));
  };
  return /*#__PURE__*/_react.default.createElement("li", {
    "data-test-subj": "runtimeFieldsListItem"
  }, /*#__PURE__*/_react.default.createElement("div", {
    css: [styles.field, areActionButtonsVisible && styles.fieldEnabled, isHighlighted && styles.fieldHighlighted, isDimmed && styles.fieldDim]
  }, /*#__PURE__*/_react.default.createElement("div", {
    css: styles.wrapperIndent
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    css: styles.content
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": "fieldName"
  }, source.name), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow",
    "data-test-subj": "fieldType",
    "data-type-value": source.type
  }, (0, _lib.getTypeLabelFromField)(source))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, renderActionButtons())))));
}
const RuntimeFieldsListItem = exports.RuntimeFieldsListItem = /*#__PURE__*/_react.default.memo(RuntimeFieldsListItemComponent);