"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MergeCandidates = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _venn_diagram = require("../venn_diagram");
var _styles = require("../../styles");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MergeCandidates = ({
  workspace,
  mergeCandidates,
  onSetControl
}) => {
  const performMerge = (parentId, childId) => {
    const tempMergeCandidates = [...mergeCandidates];
    let found = true;
    while (found) {
      found = false;
      for (let i = 0; i < tempMergeCandidates.length; i++) {
        const term = tempMergeCandidates[i];
        if (term.id1 === childId || term.id2 === childId) {
          tempMergeCandidates.splice(i, 1);
          found = true;
          break;
        }
      }
    }
    workspace.mergeIds(parentId, childId);
    onSetControl('none');
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    css: _styles.gphSidebarPanelStyles
  }, /*#__PURE__*/_react.default.createElement("div", {
    css: _styles.gphSidebarHeaderStyles
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "link"
  }), ' ', _i18n.i18n.translate('xpack.graph.sidebar.linkSummaryTitle', {
    defaultMessage: 'Link summary'
  })), mergeCandidates.length === 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    style: {
      minHeight: 101
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    component: "span"
  }, _i18n.i18n.translate('xpack.graph.sidebar.linkSummary.noData', {
    defaultMessage: 'No terms intersection found for the link selection.'
  }))), mergeCandidates.map(mc => {
    const mergeTerm1ToTerm2ButtonMsg = _i18n.i18n.translate('xpack.graph.sidebar.linkSummary.mergeTerm1ToTerm2ButtonTooltip', {
      defaultMessage: 'Merge {term1} into {term2}',
      values: {
        term1: mc.term1,
        term2: mc.term2
      }
    });
    const mergeTerm2ToTerm1ButtonMsg = _i18n.i18n.translate('xpack.graph.sidebar.linkSummary.mergeTerm2ToTerm1ButtonTooltip', {
      defaultMessage: 'Merge {term2} into {term1}',
      values: {
        term1: mc.term1,
        term2: mc.term2
      }
    });
    const leftTermCountMsg = _i18n.i18n.translate('xpack.graph.sidebar.linkSummary.leftTermCountTooltip', {
      defaultMessage: '{count} documents have term {term}',
      values: {
        count: mc.v1,
        term: mc.term1
      }
    });
    const bothTermsCountMsg = _i18n.i18n.translate('xpack.graph.sidebar.linkSummary.bothTermsCountTooltip', {
      defaultMessage: '{count} documents have both terms',
      values: {
        count: mc.overlap
      }
    });
    const rightTermCountMsg = _i18n.i18n.translate('xpack.graph.sidebar.linkSummary.rightTermCountTooltip', {
      defaultMessage: '{count} documents have term {term}',
      values: {
        count: mc.v2,
        term: mc.term2
      }
    });
    const onMergeTerm1ToTerm2Click = () => performMerge(mc.id2, mc.id1);
    const onMergeTerm2ToTerm1Click = () => performMerge(mc.id1, mc.id2);
    return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: mergeTerm1ToTerm2ButtonMsg,
      disableScreenReaderOutput: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      iconType: "doubleArrowRight",
      size: "xs",
      style: {
        opacity: 0.2 + mc.overlap / mc.v1
      },
      "aria-label": mergeTerm1ToTerm2ButtonMsg,
      onClick: onMergeTerm1ToTerm2Click
    })), /*#__PURE__*/_react.default.createElement("span", {
      className: "gphLinkSummary__term--1",
      css: styles.term1
    }, mc.term1), /*#__PURE__*/_react.default.createElement("span", {
      className: "gphLinkSummary__term--2",
      css: styles.term2
    }, mc.term2), /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: mergeTerm2ToTerm1ButtonMsg,
      disableScreenReaderOutput: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      iconType: "doubleArrowLeft",
      size: "xs",
      style: {
        opacity: 0.2 + mc.overlap / mc.v2
      },
      "aria-label": mergeTerm2ToTerm1ButtonMsg,
      onClick: onMergeTerm2ToTerm1Click
    }))), /*#__PURE__*/_react.default.createElement(_venn_diagram.VennDiagram, {
      leftValue: mc.v1,
      rightValue: mc.v2,
      overlap: mc.overlap
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: leftTermCountMsg
    }, /*#__PURE__*/_react.default.createElement("small", {
      className: "gphLinkSummary__term--1",
      css: styles.term1
    }, mc.v1)), /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: bothTermsCountMsg
    }, /*#__PURE__*/_react.default.createElement("small", {
      className: "gphLinkSummary__term--1-2",
      css: styles.term1_2
    }, "\xA0(", mc.overlap, ")\xA0")), /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: rightTermCountMsg
    }, /*#__PURE__*/_react.default.createElement("small", {
      className: "gphLinkSummary__term--2",
      css: styles.term2
    }, mc.v2)));
  }));
};
exports.MergeCandidates = MergeCandidates;
const styles = {
  term1: ({
    euiTheme
  }) => (0, _react2.css)({
    color: euiTheme.colors.danger
  }),
  term2: ({
    euiTheme
  }) => (0, _react2.css)({
    color: euiTheme.colors.primary
  }),
  term1_2: ({
    euiTheme
  }) => (0, _react2.css)`
    color: color-mix(in srgb, ${euiTheme.colors.danger}, ${euiTheme.colors.primary});
  `
};