"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NewAgentPolicySchema = exports.GetListAgentPolicyOutputsResponseSchema = exports.GetAutoUpgradeAgentsStatusResponseSchema = exports.GetAgentPolicyResponseSchema = exports.GetAgentPolicyOutputsResponseSchema = exports.FullAgentPolicyResponseSchema = exports.AgentPolicySchema = exports.AgentPolicyResponseSchema = exports.AgentPolicyNamespaceSchema = exports.AgentPolicyBaseSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _constants = require("../../../common/constants");
var _services = require("../../../common/services");
var _form_settings = require("../../services/form_settings");
var _package_policy = require("./package_policy");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AgentPolicyNamespaceSchema = exports.AgentPolicyNamespaceSchema = _configSchema.schema.string({
  minLength: 1,
  validate: value => {
    const namespaceValidation = (0, _services.isValidNamespace)(value || '');
    if (!namespaceValidation.valid && namespaceValidation.error) {
      return namespaceValidation.error;
    }
  }
});
function validateNonEmptyString(val) {
  if (val.trim() === '') {
    return 'Invalid empty string';
  }
}
const TWO_WEEKS_SECONDS = 1209600;
function isInteger(n) {
  if (!Number.isInteger(n)) {
    return `${n} is not a valid integer`;
  }
}
const memoryRegex = /^\d+(Mi|Gi)$/;
function validateMemory(s) {
  if (!memoryRegex.test(s)) {
    return 'Invalid memory format';
  }
}
const cpuRegex = /^(\d+m|\d+(\.\d+)?)$/;
function validateCPU(s) {
  if (!cpuRegex.test(s)) {
    return 'Invalid CPU format';
  }
}
function validateCloudProvider(s) {
  const csps = ['aws', 'azure', 'gcp'];
  if (!csps.includes(s)) {
    return 'Invalid cloud provider';
  }
}
const AgentPolicyBaseSchema = exports.AgentPolicyBaseSchema = {
  id: _configSchema.schema.maybe(_configSchema.schema.string()),
  space_ids: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
  name: _configSchema.schema.string({
    minLength: 1,
    validate: validateNonEmptyString
  }),
  namespace: AgentPolicyNamespaceSchema,
  description: _configSchema.schema.maybe(_configSchema.schema.string()),
  is_managed: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  has_fleet_server: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  is_default: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  is_default_fleet_server: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  unenroll_timeout: _configSchema.schema.maybe(_configSchema.schema.number({
    min: 0,
    validate: isInteger
  })),
  inactivity_timeout: _configSchema.schema.number({
    min: 0,
    defaultValue: TWO_WEEKS_SECONDS,
    validate: isInteger
  }),
  monitoring_enabled: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.oneOf([_configSchema.schema.literal(_constants.dataTypes.Logs), _configSchema.schema.literal(_constants.dataTypes.Metrics), _configSchema.schema.literal(_constants.dataTypes.Traces)]))),
  keep_monitoring_alive: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal(null), _configSchema.schema.boolean({
    defaultValue: false,
    meta: {
      description: 'When set to true, monitoring will be enabled but logs/metrics collection will be disabled'
    }
  })])),
  data_output_id: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal(null), _configSchema.schema.string()])),
  monitoring_output_id: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal(null), _configSchema.schema.string()])),
  download_source_id: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal(null), _configSchema.schema.string()])),
  fleet_server_host_id: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal(null), _configSchema.schema.string()])),
  agent_features: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.object({
    name: _configSchema.schema.string(),
    enabled: _configSchema.schema.boolean()
  }))),
  is_protected: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  overrides: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal(null), _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.any(), {
    validate: val => {
      if (Object.keys(val).some(key => key.match(/^inputs(\.)?/))) {
        return 'inputs overrides is not allowed';
      }
    },
    meta: {
      description: 'Override settings that are defined in the agent policy. Input settings cannot be overridden. The override option should be used only in unusual circumstances and not as a routine procedure.'
    }
  })])),
  ...(0, _form_settings.getSettingsAPISchema)('AGENT_POLICY_ADVANCED_SETTINGS'),
  supports_agentless: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal(null), _configSchema.schema.boolean({
    defaultValue: false,
    meta: {
      description: 'Indicates whether the agent policy supports agentless integrations.'
    }
  })])),
  global_data_tags: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.object({
    name: _configSchema.schema.string(),
    value: _configSchema.schema.oneOf([_configSchema.schema.string(), _configSchema.schema.number()])
  }), {
    validate: validateGlobalDataTagInput,
    meta: {
      description: 'User defined data tags that are added to all of the inputs. The values can be strings or numbers.'
    }
  })),
  agentless: _configSchema.schema.maybe(_configSchema.schema.object({
    cloud_connectors: _configSchema.schema.maybe(_configSchema.schema.object({
      target_csp: _configSchema.schema.maybe(_configSchema.schema.string({
        validate: validateCloudProvider
      })),
      enabled: _configSchema.schema.boolean()
    })),
    resources: _configSchema.schema.maybe(_configSchema.schema.object({
      requests: _configSchema.schema.maybe(_configSchema.schema.object({
        memory: _configSchema.schema.maybe(_configSchema.schema.string({
          validate: validateMemory
        })),
        cpu: _configSchema.schema.maybe(_configSchema.schema.string({
          validate: validateCPU
        }))
      }))
    }))
  })),
  monitoring_pprof_enabled: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  monitoring_http: _configSchema.schema.maybe(_configSchema.schema.object({
    enabled: _configSchema.schema.maybe(_configSchema.schema.boolean()),
    host: _configSchema.schema.maybe(_configSchema.schema.string({
      defaultValue: 'localhost'
    })),
    port: _configSchema.schema.maybe(_configSchema.schema.number({
      min: 0,
      max: 65353,
      defaultValue: 6791
    })),
    buffer: _configSchema.schema.maybe(_configSchema.schema.object({
      enabled: _configSchema.schema.boolean({
        defaultValue: false
      })
    }))
  })),
  monitoring_diagnostics: _configSchema.schema.maybe(_configSchema.schema.object({
    limit: _configSchema.schema.maybe(_configSchema.schema.object({
      interval: _configSchema.schema.maybe(_configSchema.schema.string()),
      burst: _configSchema.schema.maybe(_configSchema.schema.number())
    })),
    uploader: _configSchema.schema.maybe(_configSchema.schema.object({
      max_retries: _configSchema.schema.maybe(_configSchema.schema.number()),
      init_dur: _configSchema.schema.maybe(_configSchema.schema.string()),
      max_dur: _configSchema.schema.maybe(_configSchema.schema.string())
    }))
  })),
  required_versions: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal(null), _configSchema.schema.arrayOf(_configSchema.schema.object({
    version: _configSchema.schema.string({
      meta: {
        description: 'Target version for automatic agent upgrade'
      }
    }),
    percentage: _configSchema.schema.number({
      min: 0,
      max: 100,
      meta: {
        description: 'Target percentage of agents to auto upgrade'
      }
    })
  }))]))
};
function validateGlobalDataTagInput(tags) {
  const seen = new Set([]);
  const duplicates = [];
  const namesWithSpaces = [];
  const errors = [];
  for (const tag of tags) {
    if (/\s/.test(tag.name)) {
      namesWithSpaces.push(`'${tag.name}'`);
    }
    if (!seen.has(tag.name.trim())) {
      seen.add(tag.name.trim());
    } else {
      duplicates.push(`'${tag.name.trim()}'`);
    }
  }
  if (duplicates.length !== 0) {
    errors.push(`Found duplicate tag names: [${duplicates.join(', ')}], duplicate tag names are not allowed.`);
  }
  if (namesWithSpaces.length !== 0) {
    errors.push(`Found tag names with spaces: [${namesWithSpaces.join(', ')}], tag names with spaces are not allowed.`);
  }
  if (errors.length !== 0) {
    return errors.join(' ');
  }
}
const BaseSSLSchema = _configSchema.schema.object({
  verification_mode: _configSchema.schema.maybe(_configSchema.schema.string()),
  certificate_authorities: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
  certificate: _configSchema.schema.maybe(_configSchema.schema.string()),
  key: _configSchema.schema.maybe(_configSchema.schema.string()),
  renegotiation: _configSchema.schema.maybe(_configSchema.schema.string())
});
const BaseSecretsSchema = _configSchema.schema.object({
  ssl: _configSchema.schema.maybe(_configSchema.schema.object({
    key: _configSchema.schema.object({
      id: _configSchema.schema.maybe(_configSchema.schema.string())
    })
  }))
}).extendsDeep({
  unknowns: 'allow'
});
const NewAgentPolicySchema = exports.NewAgentPolicySchema = _configSchema.schema.object({
  ...AgentPolicyBaseSchema,
  force: _configSchema.schema.maybe(_configSchema.schema.boolean())
});
const AgentPolicySchema = exports.AgentPolicySchema = _configSchema.schema.object({
  ...AgentPolicyBaseSchema,
  id: _configSchema.schema.string(),
  is_managed: _configSchema.schema.boolean(),
  status: _configSchema.schema.oneOf([_configSchema.schema.literal(_constants.agentPolicyStatuses.Active), _configSchema.schema.literal(_constants.agentPolicyStatuses.Inactive)]),
  package_policies: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.arrayOf(_configSchema.schema.string()), _configSchema.schema.arrayOf(_package_policy.PackagePolicySchema)])),
  updated_at: _configSchema.schema.string(),
  updated_by: _configSchema.schema.string()
});
const AgentPolicyResponseSchema = exports.AgentPolicyResponseSchema = AgentPolicySchema.extends({
  revision: _configSchema.schema.number(),
  agents: _configSchema.schema.maybe(_configSchema.schema.number()),
  unprivileged_agents: _configSchema.schema.maybe(_configSchema.schema.number()),
  is_protected: _configSchema.schema.boolean({
    meta: {
      description: 'Indicates whether the agent policy has tamper protection enabled. Default false.'
    }
  }),
  version: _configSchema.schema.maybe(_configSchema.schema.string()),
  is_preconfigured: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  schema_version: _configSchema.schema.maybe(_configSchema.schema.string()),
  package_policies: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.arrayOf(_configSchema.schema.string()), _configSchema.schema.arrayOf(_package_policy.PackagePolicyResponseSchema, {
    meta: {
      description: 'This field is present only when retrieving a single agent policy, or when retrieving a list of agent policies with the ?full=true parameter'
    }
  })]))
});
const GetAgentPolicyResponseSchema = exports.GetAgentPolicyResponseSchema = _configSchema.schema.object({
  item: AgentPolicyResponseSchema
});
const GetAutoUpgradeAgentsStatusResponseSchema = exports.GetAutoUpgradeAgentsStatusResponseSchema = _configSchema.schema.object({
  currentVersions: _configSchema.schema.arrayOf(_configSchema.schema.object({
    version: _configSchema.schema.string(),
    agents: _configSchema.schema.number(),
    failedUpgradeAgents: _configSchema.schema.number()
  })),
  totalAgents: _configSchema.schema.number()
});
const FullAgentPolicyResponseSchema = exports.FullAgentPolicyResponseSchema = _configSchema.schema.object({
  id: _configSchema.schema.string(),
  namespaces: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
  outputs: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.object({
    type: _configSchema.schema.string(),
    hosts: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
    ca_sha256: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal(null), _configSchema.schema.string()])),
    proxy_url: _configSchema.schema.maybe(_configSchema.schema.string()),
    proxy_headers: _configSchema.schema.maybe(_configSchema.schema.any())
  })).extendsDeep({
    unknowns: 'allow'
  }),
  output_permissions: _configSchema.schema.maybe(_configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.any()))),
  fleet: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.object({
    hosts: _configSchema.schema.arrayOf(_configSchema.schema.string()),
    proxy_url: _configSchema.schema.maybe(_configSchema.schema.string()),
    proxy_headers: _configSchema.schema.maybe(_configSchema.schema.any()),
    ssl: _configSchema.schema.maybe(BaseSSLSchema),
    secrets: _configSchema.schema.maybe(BaseSecretsSchema)
  }), _configSchema.schema.object({
    kibana: _configSchema.schema.object({
      hosts: _configSchema.schema.arrayOf(_configSchema.schema.string()),
      protocol: _configSchema.schema.string(),
      path: _configSchema.schema.maybe(_configSchema.schema.string())
    })
  })])),
  inputs: _configSchema.schema.arrayOf(_configSchema.schema.object({
    id: _configSchema.schema.string(),
    name: _configSchema.schema.string(),
    revision: _configSchema.schema.number(),
    type: _configSchema.schema.string(),
    data_stream: _configSchema.schema.object({
      namespace: _configSchema.schema.string()
    }),
    use_output: _configSchema.schema.string(),
    package_policy_id: _configSchema.schema.string(),
    meta: _configSchema.schema.maybe(_configSchema.schema.object({
      package: _configSchema.schema.maybe(_configSchema.schema.object({
        name: _configSchema.schema.string(),
        version: _configSchema.schema.string()
      })).extendsDeep({
        unknowns: 'allow'
      })
    })),
    streams: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.object({
      id: _configSchema.schema.string(),
      data_stream: _configSchema.schema.object({
        dataset: _configSchema.schema.string(),
        type: _configSchema.schema.maybe(_configSchema.schema.string())
      })
    })).extendsDeep({
      unknowns: 'allow'
    })),
    processors: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.object({
      add_fields: _configSchema.schema.object({
        target: _configSchema.schema.string(),
        fields: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.oneOf([_configSchema.schema.string(), _configSchema.schema.number()]))
      })
    })))
  }).extendsDeep({
    unknowns: 'allow'
  })),
  revision: _configSchema.schema.maybe(_configSchema.schema.number()),
  agent: _configSchema.schema.maybe(_configSchema.schema.object({
    monitoring: _configSchema.schema.object({
      namespace: _configSchema.schema.maybe(_configSchema.schema.string()),
      use_output: _configSchema.schema.maybe(_configSchema.schema.string()),
      enabled: _configSchema.schema.boolean(),
      metrics: _configSchema.schema.boolean(),
      logs: _configSchema.schema.boolean(),
      traces: _configSchema.schema.boolean(),
      apm: _configSchema.schema.maybe(_configSchema.schema.any()),
      _runtime_experimental: _configSchema.schema.maybe(_configSchema.schema.string())
    }),
    download: _configSchema.schema.object({
      sourceURI: _configSchema.schema.string(),
      ssl: _configSchema.schema.maybe(BaseSSLSchema),
      secrets: _configSchema.schema.maybe(BaseSecretsSchema),
      timeout: _configSchema.schema.maybe(_configSchema.schema.string()),
      target_directory: _configSchema.schema.maybe(_configSchema.schema.string())
    }),
    features: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.object({
      enabled: _configSchema.schema.boolean()
    })),
    protection: _configSchema.schema.maybe(_configSchema.schema.object({
      enabled: _configSchema.schema.boolean(),
      uninstall_token_hash: _configSchema.schema.string(),
      signing_key: _configSchema.schema.string()
    })),
    logging: _configSchema.schema.maybe(_configSchema.schema.object({
      level: _configSchema.schema.maybe(_configSchema.schema.string()),
      to_files: _configSchema.schema.maybe(_configSchema.schema.boolean()),
      files: _configSchema.schema.maybe(_configSchema.schema.object({
        rotateeverybytes: _configSchema.schema.maybe(_configSchema.schema.number()),
        keepfiles: _configSchema.schema.maybe(_configSchema.schema.number()),
        interval: _configSchema.schema.maybe(_configSchema.schema.string())
      })),
      metrics: _configSchema.schema.maybe(_configSchema.schema.object({
        period: _configSchema.schema.maybe(_configSchema.schema.string())
      }))
    })),
    limits: _configSchema.schema.maybe(_configSchema.schema.object({
      go_max_procs: _configSchema.schema.maybe(_configSchema.schema.number())
    }))
  })),
  secret_references: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.object({
    id: _configSchema.schema.string()
  }))),
  signed: _configSchema.schema.maybe(_configSchema.schema.object({
    data: _configSchema.schema.string(),
    signature: _configSchema.schema.string()
  }))
});
const MinimalOutputSchema = _configSchema.schema.object({
  id: _configSchema.schema.string(),
  name: _configSchema.schema.string()
});
const IntegrationsOutputSchema = _configSchema.schema.arrayOf(_configSchema.schema.object({
  pkgName: _configSchema.schema.maybe(_configSchema.schema.string()),
  integrationPolicyName: _configSchema.schema.maybe(_configSchema.schema.string()),
  id: _configSchema.schema.maybe(_configSchema.schema.string()),
  name: _configSchema.schema.maybe(_configSchema.schema.string())
}));
const OutputsForAgentPolicySchema = _configSchema.schema.object({
  agentPolicyId: _configSchema.schema.maybe(_configSchema.schema.string()),
  monitoring: _configSchema.schema.object({
    output: MinimalOutputSchema
  }),
  data: _configSchema.schema.object({
    output: MinimalOutputSchema,
    integrations: _configSchema.schema.maybe(IntegrationsOutputSchema)
  })
});
const GetAgentPolicyOutputsResponseSchema = exports.GetAgentPolicyOutputsResponseSchema = _configSchema.schema.object({
  item: OutputsForAgentPolicySchema
});
const GetListAgentPolicyOutputsResponseSchema = exports.GetListAgentPolicyOutputsResponseSchema = _configSchema.schema.object({
  items: _configSchema.schema.arrayOf(OutputsForAgentPolicySchema)
});