"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.findAgentlessPolicies = findAgentlessPolicies;
var _agent_policy = require("../agent_policy");
var _app_context = require("../app_context");
var _constants = require("../../constants");
var _constants2 = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Returns agentless policies that may need their data output ID updated
// If outputId is provided, return agentless policies that use that output in addition
// to policies that don't have an output set
async function findAgentlessPolicies(outputId) {
  const internalSoClientWithoutSpaceExtension = _app_context.appContextService.getInternalUserSOClientWithoutSpaceExtension();
  const agentlessPolicies = await _agent_policy.agentPolicyService.list(internalSoClientWithoutSpaceExtension, {
    spaceId: '*',
    perPage: _constants2.SO_SEARCH_LIMIT,
    kuery: `${_constants.LEGACY_AGENT_POLICY_SAVED_OBJECT_TYPE}.supports_agentless:true`
  });
  if (outputId) {
    return agentlessPolicies.items.filter(policy => policy.data_output_id === outputId || !policy.data_output_id);
  } else {
    return agentlessPolicies.items.filter(policy => !policy.data_output_id);
  }
}