"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTemplateUrlFromPackageInfo = exports.SUPPORTED_TEMPLATES_URL_FROM_PACKAGE_INFO_INPUT_VARS = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SUPPORTED_TEMPLATES_URL_FROM_PACKAGE_INFO_INPUT_VARS = exports.SUPPORTED_TEMPLATES_URL_FROM_PACKAGE_INFO_INPUT_VARS = {
  CLOUD_FORMATION: 'cloud_formation_template',
  CLOUD_FORMATION_CREDENTIALS: 'cloud_formation_credentials_template',
  ARM_TEMPLATE: 'arm_template_url',
  CLOUD_SHELL_URL: 'cloud_shell_url'
};
const getTemplateUrlFromPackageInfo = (packageInfo, integrationType, templateUrlFieldName) => {
  if (!(packageInfo !== null && packageInfo !== void 0 && packageInfo.policy_templates)) return undefined;
  const policyTemplate = packageInfo.policy_templates.find(p => p.name === integrationType);
  if (!policyTemplate) return undefined;
  if ('inputs' in policyTemplate) {
    var _policyTemplate$input;
    const cloudFormationTemplate = (_policyTemplate$input = policyTemplate.inputs) === null || _policyTemplate$input === void 0 ? void 0 : _policyTemplate$input.reduce((acc, input) => {
      var _input$vars$find;
      if (!input.vars) return acc;
      const template = (_input$vars$find = input.vars.find(v => v.name === templateUrlFieldName)) === null || _input$vars$find === void 0 ? void 0 : _input$vars$find.default;
      return template ? String(template) : acc;
    }, '');
    return cloudFormationTemplate !== '' ? cloudFormationTemplate : undefined;
  }
};
exports.getTemplateUrlFromPackageInfo = getTemplateUrlFromPackageInfo;