"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditIntegrationFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _hooks = require("../../../../../../../hooks");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EditIntegrationFlyout = ({
  onClose,
  integrationName,
  miniIcon,
  packageInfo,
  setIsEditOpen,
  integration,
  services,
  onComplete,
  existingCategories
}) => {
  const updateCustomIntegration = _hooks.useUpdateCustomIntegration;

  // Get all the possible categories
  const {
    data: categoriesData
  } = (0, _hooks.useGetCategoriesQuery)({
    prerelease: false
  });
  // We only need the parent categories for now, filter out any with parent_id fields to only leave the parents
  const parentCategories = categoriesData === null || categoriesData === void 0 ? void 0 : categoriesData.items.filter(item => item.parent_id === undefined);

  // state section
  const [savingEdits, setSavingEdits] = (0, _react.useState)(false);
  const [selectedCategories, setSelectedCategories] = (0, _react.useState)([]);
  const [editedContent, setEditedContent] = (0, _react.useState)();
  const [readmeLoading, setReadmeLoading] = (0, _react.useState)(true);
  const categoriesInitialized = (0, _react.useRef)(false);

  // Only run this when we havent initialized and we have everything we need. No need for an effect
  if (parentCategories !== null && parentCategories !== void 0 && parentCategories.length && existingCategories.length && !categoriesInitialized.current) {
    const initialCategories = existingCategories.map(categoryId => {
      const category = parentCategories.find(cat => cat.id === categoryId);
      if (category) {
        return {
          label: category.title,
          value: category.id
        };
      }
    }).filter(cat => cat !== undefined); // filter out any undefined values due to typing
    if (initialCategories.length) {
      setSelectedCategories(initialCategories);
      categoriesInitialized.current = true;
    }
  }

  // get the readme content from the packageInfo
  (0, _react.useEffect)(() => {
    const readmePath = packageInfo === null || packageInfo === void 0 ? void 0 : packageInfo.readme;
    if (!readmePath) {
      setReadmeLoading(false);
      return;
    }
    (0, _hooks.sendGetFileByPath)(readmePath).then(res => {
      setEditedContent(res.data || '');
      setReadmeLoading(false);
    });
  }, [packageInfo]);
  const saveIntegrationEdits = async updatedReadMe => {
    setSavingEdits(true);
    const res = await updateCustomIntegration((packageInfo === null || packageInfo === void 0 ? void 0 : packageInfo.name) || '', {
      readMeData: updatedReadMe,
      categories: selectedCategories.map(item => item.value) // filter out any undefined values due to typing
    });
    setSavingEdits(false);
    setIsEditOpen(false);
    // if everything is okay, then show success and redirect to new page
    if (!res.error) {
      services.notifications.toasts.addSuccess({
        title: _i18n.i18n.translate('xpack.fleet.epm.editIntegrationSuccessToastTitle', {
          defaultMessage: 'Integration updated'
        }),
        text: _i18n.i18n.translate('xpack.fleet.epm.editIntegrationSuccessToastText', {
          defaultMessage: 'The integration has been updated successfully. Redirecting you to the updated integration.'
        })
      });
      setTimeout(() => {
        // navigate to new page after 2 seconds
        const urlParts = {
          pkgkey: `${packageInfo === null || packageInfo === void 0 ? void 0 : packageInfo.name}-${res.data.result.version}`,
          ...(integration ? {
            integration
          } : {})
        };
        onComplete(urlParts);
      }, 2000);
    } else {
      services.notifications.toasts.addError(res.error, {
        title: _i18n.i18n.translate('xpack.fleet.epm.editIntegrationErrorToastTitle', {
          defaultMessage: 'Error updating integration.'
        }),
        toastMessage: _i18n.i18n.translate('xpack.fleet.epm.editIntegrationErrorToastText', {
          defaultMessage: 'There was an error updating the integration.'
        })
      });
    }
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    ownFocus: true,
    onClose: onClose,
    "aria-labelledby": "editIntegrationFlyoutTitle"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, miniIcon), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", {
    id: "editIntegrationFlyoutTitle"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.epm.editIntegrationFlyout.title",
    defaultMessage: "Editing {integrationName}",
    values: {
      integrationName
    }
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.epm.editIntegrationFlyout.categoriesLabel",
      defaultMessage: "Integration Categories"
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.epm.editIntegrationFlyout.categoriesHelpText",
      defaultMessage: "You can assign up to two categories to your integration."
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    fullWidth: true,
    "data-test-subj": "editIntegrationFlyoutCategories",
    "aria-label": "Select categories",
    placeholder: "Select categories",
    selectedOptions: selectedCategories,
    options: parentCategories === null || parentCategories === void 0 ? void 0 : parentCategories.map(category => ({
      label: category.title,
      value: category.id,
      disabled: selectedCategories.length >= 2
    })),
    onChange: selectedOptions => {
      const selectedValues = selectedOptions;
      setSelectedCategories(selectedValues.filter(option => option.value !== undefined));
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), readmeLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null) : /*#__PURE__*/_react.default.createElement(_eui.EuiMarkdownEditor, {
    "aria-label": "Edit",
    placeholder: `${_i18n.i18n.translate('xpack.fleet.epm.editIntegrationFlyout.markdownEditorPlaceholder', {
      defaultMessage: 'Edit the README content for {integrationName}...',
      values: {
        integrationName
      }
    })}...`,
    value: editedContent,
    onChange: setEditedContent,
    readOnly: false,
    height: 600
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onClose
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.editIntegrationFlyout.cancelButtonLabel",
    defaultMessage: "Cancel"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    isLoading: savingEdits,
    fill: true,
    color: "primary",
    onClick: () => saveIntegrationEdits(editedContent)
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.editIntegrationFlyout.saveButtonLabel",
    defaultMessage: "Save Changes"
  }))))));
};
exports.EditIntegrationFlyout = EditIntegrationFlyout;