"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IntegrationStatusBadge = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const IntegrationStatusBadge = ({
  status,
  onClick,
  onClickAriaLabel
}) => {
  const onClickProps = onClick && onClickAriaLabel ? {
    onClick,
    onClickAriaLabel
  } : {};
  const IntegrationSyncStatusBadge = {
    FAILED: /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, (0, _extends2.default)({
      color: "danger",
      "data-test-subj": "integrationSyncFailedBadge",
      iconType: "errorFilled"
    }, onClickProps), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.integrationSyncStatus.failedText",
      defaultMessage: "Failed"
    })),
    WARNING: /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, (0, _extends2.default)({
      color: "warning",
      "data-test-subj": "integrationSyncWarningBadge",
      iconType: "warning"
    }, onClickProps), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.integrationSyncStatus.warningText",
      defaultMessage: "Warning"
    })),
    COMPLETED: /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, (0, _extends2.default)({
      color: "success",
      "data-test-subj": "integrationSyncCompletedBadge",
      iconType: "check"
    }, onClickProps), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.integrationSyncStatus.completedText",
      defaultMessage: "Completed"
    })),
    SYNCHRONIZING: /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, (0, _extends2.default)({
      color: "hollow",
      "data-test-subj": "integrationSyncSyncingBadge"
    }, onClickProps), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      justifyContent: "flexStart",
      gutterSize: "xs"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "s"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.integrationSyncStatus.syncingText",
      defaultMessage: "Syncing..."
    })))),
    NA: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "baseline",
      justifyContent: "flexStart",
      gutterSize: "xs"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "subdued",
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.integrationSyncStatus.naText",
      defaultMessage: "N/A"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: _i18n.i18n.translate('xpack.fleet.integrationSyncStatus.naTooltip', {
        defaultMessage: 'Integration syncing only applies to remote outputs.'
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "info",
      color: "subdued"
    })))),
    DISABLED: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "baseline",
      justifyContent: "flexStart",
      gutterSize: "xs"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "subdued",
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.integrationSyncStatus.disabledText",
      defaultMessage: "Sync disabled"
    }), ' ')), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: _i18n.i18n.translate('xpack.fleet.integrationSyncStatus.disabledTooltip', {
        defaultMessage: 'Integration syncing is disabled for this remote output. Enable it by clicking the edit icon and updating the output settings.'
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "info",
      color: "subdued"
    }))))
  };
  return IntegrationSyncStatusBadge[status];
};
exports.IntegrationStatusBadge = IntegrationStatusBadge;