"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditOutputFlyout = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _jsYaml = require("js-yaml");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _output_helpers = require("../../../../../../../common/services/output_helpers");
var _constants = require("../../../../../../../common/constants");
var _constants2 = require("../../../../constants");
var _hooks = require("../../../../hooks");
var _proxy_warning = require("../fleet_proxies_table/proxy_warning");
var _output_form_kafka = require("./output_form_kafka");
var _yaml_code_editor_with_placeholder = require("./yaml_code_editor_with_placeholder");
var _use_output_form = require("./use_output_form");
var _advanced_options_section = require("./advanced_options_section");
var _output_form_remote_es = require("./output_form_remote_es");
var _output_health = require("./output_health");
var _output_form_logstash = require("./output_form_logstash");
var _output_form_elasticsearch = require("./output_form_elasticsearch");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EditOutputFlyout = ({
  defaultOuput,
  onClose,
  output,
  proxies
}) => {
  (0, _hooks.useBreadcrumbs)('settings');
  const form = (0, _use_output_form.useOutputForm)(onClose, output, defaultOuput);
  const inputs = form.inputs;
  const {
    docLinks,
    cloud
  } = (0, _hooks.useStartServices)();
  const fleetStatus = (0, _hooks.useFleetStatus)();
  const isServerless = !!(cloud !== null && cloud !== void 0 && cloud.isServerlessEnabled);
  const [secretsToggleState, setSecretsToggleState] = (0, _react.useState)('disabled');
  if (fleetStatus.isSecretsStorageEnabled !== undefined && secretsToggleState === 'disabled') {
    setSecretsToggleState(fleetStatus.isSecretsStorageEnabled);
  }
  const onToggleSecretStorage = secretEnabled => {
    if (secretsToggleState === 'disabled') {
      return;
    }
    setSecretsToggleState(secretEnabled);
  };
  const useSecretsStorage = secretsToggleState === true;
  const proxiesOptions = (0, _react.useMemo)(() => proxies.map(proxy => ({
    value: proxy.id,
    label: proxy.name
  })), [proxies]);
  const isRemoteESOutput = inputs.typeInput.value === _constants.outputType.RemoteElasticsearch;
  const isESOutput = inputs.typeInput.value === _constants.outputType.Elasticsearch;
  const supportsPresets = inputs.typeInput.value ? (0, _output_helpers.outputTypeSupportPresets)(inputs.typeInput.value) : false;

  // Remote ES output not yet supported in serverless
  const isStateful = !(cloud !== null && cloud !== void 0 && cloud.isServerlessEnabled);
  const OUTPUT_TYPE_OPTIONS = [{
    value: _constants.outputType.Elasticsearch,
    text: 'Elasticsearch'
  }, ...(isStateful ? [{
    value: _constants.outputType.RemoteElasticsearch,
    text: 'Remote Elasticsearch'
  }] : []), {
    value: _constants.outputType.Logstash,
    text: 'Logstash'
  }, {
    value: _constants.outputType.Kafka,
    text: 'Kafka'
  }];
  const renderLogstashSection = () => {
    return /*#__PURE__*/_react.default.createElement(_output_form_logstash.OutputFormLogstashSection, {
      inputs: inputs,
      useSecretsStorage: useSecretsStorage,
      onToggleSecretStorage: onToggleSecretStorage,
      hasEncryptedSavedObjectConfigured: form.hasEncryptedSavedObjectConfigured
    });
  };
  const renderElasticsearchSection = () => {
    return /*#__PURE__*/_react.default.createElement(_output_form_elasticsearch.OutputFormElasticsearchSection, {
      inputs: inputs,
      useSecretsStorage: useSecretsStorage,
      onToggleSecretStorage: onToggleSecretStorage
    });
  };
  const renderRemoteElasticsearchSection = () => {
    return /*#__PURE__*/_react.default.createElement(_output_form_remote_es.OutputFormRemoteEsSection, {
      inputs: inputs,
      useSecretsStorage: useSecretsStorage,
      onToggleSecretStorage: onToggleSecretStorage
    });
  };
  const renderKafkaSection = () => {
    return /*#__PURE__*/_react.default.createElement(_output_form_kafka.OutputFormKafkaSection, {
      inputs: inputs,
      useSecretsStorage: useSecretsStorage,
      onToggleSecretStorage: onToggleSecretStorage
    });
  };
  const renderOutputTypeSection = type => {
    switch (type) {
      case _constants.outputType.Logstash:
        return renderLogstashSection();
      case _constants.outputType.Kafka:
        return renderKafkaSection();
      case _constants.outputType.RemoteElasticsearch:
        return renderRemoteElasticsearchSection();
      case _constants.outputType.Elasticsearch:
      default:
        return renderElasticsearchSection();
    }
  };
  const renderTypeSpecificWarning = () => {
    if (!isESOutput && !isRemoteESOutput) {
      return null;
    }
    const generateWarningMessage = () => {
      switch (inputs.typeInput.value) {
        default:
        case _constants.outputType.Elasticsearch:
          return _i18n.i18n.translate('xpack.fleet.settings.editOutputFlyout.esOutputTypeCallout', {
            defaultMessage: 'This output type does not support connectivity to a remote Elasticsearch cluster, please use the Remote Elasticsearch type for that.'
          });
        case _constants.outputType.RemoteElasticsearch:
          return _i18n.i18n.translate('xpack.fleet.settings.editOutputFlyout.remoteESOutputTypeCallout', {
            defaultMessage: 'Remote Elasticsearch output does not support connectivity to a serverless project.'
          });
      }
    };
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !isServerless ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xs"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      "data-test-subj": `settingsOutputsFlyout.${inputs.typeInput.value}OutputTypeCallout`,
      title: generateWarningMessage(),
      iconType: "alert",
      color: "warning",
      size: "s",
      heading: "p"
    })) : null, isRemoteESOutput ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.editOutputFlyout.remoteESTypeText",
      defaultMessage: "Enter your output hosts, service token for your remote cluster, and any advanced YAML configuration. Learn more about how to use these parameters in {doc}.",
      values: {
        doc: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: docLinks.links.fleet.remoteESOoutput,
          target: "_blank"
        }, _i18n.i18n.translate('xpack.fleet.settings.editOutputFlyout.docLabel', {
          defaultMessage: 'our documentation'
        }))
      }
    }))) : null);
  };
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: onClose,
    maxWidth: _constants2.MAX_FLYOUT_WIDTH,
    "aria-labelledby": modalTitleId
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: modalTitleId
  }, !output ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.settings.editOutputFlyout.createTitle",
    defaultMessage: "Add new output"
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.settings.editOutputFlyout.editTitle",
    defaultMessage: "Edit output"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, (output === null || output === void 0 ? void 0 : output.is_preconfigured) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    iconType: "lock",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.editOutputFlyout.preconfiguredOutputCalloutTitle",
      defaultMessage: "This output is managed outside of Fleet"
    })
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.settings.editOutputFlyout.preconfiguredOutputCalloutDescription",
    defaultMessage: "Most actions related to this output are unavailable. Refer to your kibana config for more detail."
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiForm, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.editOutputFlyout.nameInputLabel",
      defaultMessage: "Name"
    })
  }, inputs.nameInput.formRowProps), /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, (0, _extends2.default)({
    "data-test-subj": "settingsOutputsFlyout.nameInput",
    fullWidth: true
  }, inputs.nameInput.props, {
    placeholder: _i18n.i18n.translate('xpack.fleet.settings.editOutputFlyout.nameInputPlaceholder', {
      defaultMessage: 'Specify name'
    })
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.editOutputFlyout.typeInputLabel",
      defaultMessage: "Type"
    }))
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, (0, _extends2.default)({
    fullWidth: true,
    "data-test-subj": "settingsOutputsFlyout.typeInput"
  }, inputs.typeInput.props, {
    options: OUTPUT_TYPE_OPTIONS
  })), renderTypeSpecificWarning())), renderOutputTypeSection(inputs.typeInput.value), isRemoteESOutput ? null : /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.editOutputFlyout.proxyIdLabel",
      defaultMessage: "Proxy"
    })
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, (0, _extends2.default)({
    fullWidth: true,
    "data-test-subj": "settingsOutputsFlyout.proxyIdInput"
  }, inputs.proxyIdInput.props, {
    onChange: options => {
      var _options$0$value, _options$;
      return inputs.proxyIdInput.setValue((_options$0$value = options === null || options === void 0 ? void 0 : (_options$ = options[0]) === null || _options$ === void 0 ? void 0 : _options$.value) !== null && _options$0$value !== void 0 ? _options$0$value : '');
    },
    selectedOptions: inputs.proxyIdInput.value !== '' ? proxiesOptions.filter(option => option.value === inputs.proxyIdInput.value) : [],
    options: proxiesOptions,
    singleSelection: {
      asPlainText: true
    },
    isDisabled: inputs.proxyIdInput.props.disabled,
    isClearable: true,
    placeholder: _i18n.i18n.translate('xpack.fleet.settings.editOutputFlyout.proxyIdPlaceholder', {
      defaultMessage: 'Select proxy'
    })
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_proxy_warning.ProxyWarning, null))), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
    fullWidth: true
  }, inputs.defaultOutputInput.formRowProps), /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, (0, _extends2.default)({}, inputs.defaultOutputInput.props, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.editOutputFlyout.defaultOutputSwitchLabel",
      defaultMessage: "Make this output the default for {boldAgentIntegrations}.",
      values: {
        boldAgentIntegrations: /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.settings.editOutputFlyout.agentIntegrationsBold",
          defaultMessage: "agent integrations"
        }))
      }
    })
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
    fullWidth: true
  }, inputs.defaultMonitoringOutputInput.formRowProps), /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, (0, _extends2.default)({}, inputs.defaultMonitoringOutputInput.props, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.editOutputFlyout.defaultMontoringOutputSwitchLabel",
      defaultMessage: "Make this output the default for {boldAgentMonitoring}.",
      values: {
        boldAgentMonitoring: /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.settings.editOutputFlyout.agentMonitoringBold",
          defaultMessage: "agent monitoring"
        }))
      }
    })
  }))), supportsPresets && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.editOutputFlyout.performanceTuningLabel",
      defaultMessage: "Performance tuning"
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.editOutputFlyout.performanceTuningHelpText",
      defaultMessage: "Performance tuning presets are curated output settings for common use cases. You can also select {custom} to specify your own settings in the Advanced YAML Configuration box below. For a detailed list of settings configured by each preset, see {link}.",
      values: {
        custom: /*#__PURE__*/_react.default.createElement("strong", null, "Custom"),
        link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: docLinks.links.fleet.performancePresets,
          external: true,
          target: "_blank"
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.settings.editOutputFlyout.performanceTuningHelpTextLink",
          defaultMessage: "our documentation"
        }))
      }
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, (0, _extends2.default)({
    fullWidth: true,
    "data-test-subj": "settingsOutputsFlyout.presetInput"
  }, inputs.presetInput.props, {
    onChange: e => inputs.presetInput.setValue(e.target.value),
    disabled: inputs.presetInput.props.disabled || (0, _output_helpers.outputYmlIncludesReservedPerformanceKey)(inputs.additionalYamlConfigInput.value, _jsYaml.load),
    options: [{
      value: 'balanced',
      text: 'Balanced'
    }, {
      value: 'custom',
      text: 'Custom'
    }, {
      value: 'throughput',
      text: 'Throughput'
    }, {
      value: 'scale',
      text: 'Scale'
    }, {
      value: 'latency',
      text: 'Latency'
    }]
  })))), supportsPresets && (0, _output_helpers.outputYmlIncludesReservedPerformanceKey)(inputs.additionalYamlConfigInput.value, _jsYaml.load) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning",
    iconType: "alert",
    size: "s",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.editOutputFlyout.performanceTuningMustBeCustomWarning",
      defaultMessage: "Performance tuning preset must be \"Custom\" due to presence of reserved key in advanced YAML configuration"
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: "performanceTuningMustBeCustomWarningDetails",
    buttonContent: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.editOutputFlyout.performanceTuningMustBeCustomWarningDetails",
      defaultMessage: "Show reserved keys"
    })
  }, /*#__PURE__*/_react.default.createElement("ul", null, _constants.RESERVED_CONFIG_YML_KEYS.map(key => /*#__PURE__*/_react.default.createElement("li", {
    key: key
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, key))))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: docLinks.links.fleet.esSettings,
      external: true,
      target: "_blank"
    }, _i18n.i18n.translate('xpack.fleet.settings.editOutputFlyout.yamlConfigInputLabel', {
      defaultMessage: 'Advanced YAML configuration'
    }))
  }, inputs.additionalYamlConfigInput.formRowProps, {
    fullWidth: true
  }), /*#__PURE__*/_react.default.createElement(_yaml_code_editor_with_placeholder.YamlCodeEditorWithPlaceholder, {
    value: inputs.additionalYamlConfigInput.value,
    onChange: value => {
      if ((0, _output_helpers.outputYmlIncludesReservedPerformanceKey)(value, _jsYaml.load)) {
        inputs.presetInput.setValue('custom');
      }
      inputs.additionalYamlConfigInput.setValue(value);
    },
    disabled: inputs.additionalYamlConfigInput.props.disabled,
    placeholder: _i18n.i18n.translate('xpack.fleet.settings.editOutputFlyout.yamlConfigInputPlaceholder', {
      defaultMessage: '# YAML settings here will be added to the output section of each agent policy.'
    })
  })), /*#__PURE__*/_react.default.createElement(_advanced_options_section.AdvancedOptionsSection, {
    enabled: form.isShipperEnabled,
    inputs: inputs
  })), output !== null && output !== void 0 && output.id && output.type === 'remote_elasticsearch' ? /*#__PURE__*/_react.default.createElement(_output_health.OutputHealth, {
    output: output
  }) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onClose,
    flush: "left"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.settings.fleetServerHostsFlyout.cancelButtonLabel",
    defaultMessage: "Cancel"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    isLoading: form.isLoading,
    isDisabled: form.isDisabled,
    onClick: form.submit,
    "data-test-subj": "saveApplySettingsBtn"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.settings.fleetServerHostsFlyout.saveButton",
    defaultMessage: "Save and apply settings"
  }))))));
};
exports.EditOutputFlyout = EditOutputFlyout;