"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FleetProxyFlyout = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _constants = require("../../../../constants");
var _form = require("../form");
var _proxy_warning = require("../fleet_proxies_table/proxy_warning");
var _use_fleet_proxy_form = require("./use_fleet_proxy_form");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FleetProxyFlyout = ({
  onClose,
  fleetProxy
}) => {
  const form = (0, _use_fleet_proxy_form.useFleetProxyForm)(fleetProxy, onClose);
  const {
    inputs
  } = form;
  const flyoutTitleId = (0, _eui.useGeneratedHtmlId)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: onClose,
    maxWidth: _constants.MAX_FLYOUT_WIDTH,
    "aria-labelledby": flyoutTitleId
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: flyoutTitleId
  }, fleetProxy ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.settings.fleetProxyFlyout.editTitle",
    defaultMessage: "Edit Proxy"
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.settings.fleetProxyFlyout.addTitle",
    defaultMessage: "Add Proxy"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_proxy_warning.ProxyWarning, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    onSubmit: form.submit
  }, /*#__PURE__*/_react.default.createElement(_form.TextInput, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.fleetProxyFlyout.nameInputLabel",
      defaultMessage: "Name"
    }),
    inputProps: inputs.nameInput,
    "data-test-subj": "fleetProxyFlyout.nameInput",
    placeholder: _i18n.i18n.translate('xpack.fleet.settings.fleetProxyFlyout.nameInputPlaceholder', {
      defaultMessage: 'Specify name'
    })
  }), /*#__PURE__*/_react.default.createElement(_form.TextInput, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.fleetProxyFlyout.urlInputLabel",
      defaultMessage: "Proxy Url"
    }),
    dataTestSubj: "fleetProxyFlyout.urlInput",
    inputProps: inputs.urlInput,
    placeholder: _i18n.i18n.translate('xpack.fleet.settings.fleetProxyFlyout.urlInputPlaceholder', {
      defaultMessage: 'Specify proxy url'
    })
  }), /*#__PURE__*/_react.default.createElement(_form.TextAreaInput, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.fleetProxyFlyout.proxyHeadersLabel",
      defaultMessage: "Proxy headers"
    }),
    dataTestSubj: "fleetProxyFlyout.proxyHeadersInput",
    inputProps: inputs.proxyHeadersInput,
    placeholder: _i18n.i18n.translate('xpack.fleet.settings.fleetProxyFlyout.proxyHeadersPlaceholder', {
      defaultMessage: 'Specify proxy headers'
    })
  }), /*#__PURE__*/_react.default.createElement(_form.TextInput, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.fleetProxyFlyout.certificateAuthoritiesLabel",
      defaultMessage: "Certificate authorities"
    }),
    dataTestSubj: "fleetProxyFlyout.certificateAuthoritiesInput",
    inputProps: inputs.certificateAuthoritiesInput,
    placeholder: _i18n.i18n.translate('xpack.fleet.settings.fleetProxyFlyout.certificateAuthoritiesPlaceholder', {
      defaultMessage: 'Specify certificate authorities'
    })
  }), /*#__PURE__*/_react.default.createElement(_form.TextInput, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.fleetProxyFlyout.certificateLabel",
      defaultMessage: "Certificate"
    }),
    dataTestSubj: "fleetProxyFlyout.certificateInput",
    inputProps: inputs.certificateInput,
    placeholder: _i18n.i18n.translate('xpack.fleet.settings.fleetProxyFlyout.certificatePlaceholder', {
      defaultMessage: 'Specify certificate'
    })
  }), /*#__PURE__*/_react.default.createElement(_form.TextInput, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.fleetProxyFlyout.certificateKeyLabel",
      defaultMessage: "Certificate key"
    }),
    dataTestSubj: "fleetProxyFlyout.certificateKeyInput",
    inputProps: inputs.certificateKeyInput,
    placeholder: _i18n.i18n.translate('xpack.fleet.settings.fleetProxyFlyout.certificateKeyPlaceholder', {
      defaultMessage: 'Specify certificate key'
    })
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: () => onClose(),
    flush: "left"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.settings.fleetProxyFlyout.cancelButtonLabel",
    defaultMessage: "Cancel"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    isLoading: form.isLoading,
    isDisabled: form.isDisabled,
    onClick: form.submit,
    "data-test-subj": "saveApplySettingsBtn"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.settings.fleetProxyFlyout.saveButton",
    defaultMessage: "Save and apply settings"
  }))))));
};
exports.FleetProxyFlyout = FleetProxyFlyout;