"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentListPage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _agent_status = require("../../../../../../common/services/agent_status");
var _common = require("../../../../../../common");
var _hooks = require("../../../hooks");
var _components = require("../../../components");
var _services = require("../../../services");
var _constants = require("../../../constants");
var _components2 = require("../components");
var _use_fleet_server_unhealthy = require("../hooks/use_fleet_server_unhealthy");
var _agent_request_diagnostics_modal = require("../components/agent_request_diagnostics_modal");
var _manage_auto_upgrade_agents_modal = require("../components/manage_auto_upgrade_agents_modal");
var _components3 = require("./components");
var _agent_activity_flyout = require("./components/agent_activity_flyout");
var _hooks2 = require("./hooks");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AgentListPage = () => {
  var _agentToAddRemoveTags;
  const {
    cloud
  } = (0, _hooks.useStartServices)();
  (0, _hooks.useBreadcrumbs)('agent_list');

  // Table and search states
  const [selectedAgents, setSelectedAgents] = (0, _react.useState)([]);
  const [selectionMode, setSelectionMode] = (0, _react.useState)('manual');

  // Agent enrollment flyout state
  const [enrollmentFlyout, setEnrollmentFlyoutState] = (0, _react.useState)({
    isOpen: false
  });
  const [isAgentActivityFlyoutOpen, setAgentActivityFlyoutOpen] = (0, _react.useState)(false);
  const [isManageAutoUpgradeModalOpen, setManageAutoUpgradeModalOpen] = (0, _react.useState)(false);
  const [selectedPolicyId, setSelectedPolicyId] = (0, _react.useState)();
  const flyoutContext = (0, _hooks.useFlyoutContext)();

  // Agent actions states
  const [agentToReassign, setAgentToReassign] = (0, _react.useState)(undefined);
  const [agentToUnenroll, setAgentToUnenroll] = (0, _react.useState)(undefined);
  const [agentToGetUninstallCommand, setAgentToGetUninstallCommand] = (0, _react.useState)(undefined);
  const [agentToUpgrade, setAgentToUpgrade] = (0, _react.useState)(undefined);
  const [agentToAddRemoveTags, setAgentToAddRemoveTags] = (0, _react.useState)(undefined);
  const [tagsPopoverButton, setTagsPopoverButton] = (0, _react.useState)();
  const [showTagsAddRemove, setShowTagsAddRemove] = (0, _react.useState)(false);
  const [agentToRequestDiagnostics, setAgentToRequestDiagnostics] = (0, _react.useState)(undefined);
  const [showAgentActivityTour, setShowAgentActivityTour] = (0, _react.useState)(false);

  // migrateAgentState
  const [agentsToMigrate, setAgentsToMigrate] = (0, _react.useState)(undefined);
  const [protectedAndFleetAgents, setProtectedAndFleetAgents] = (0, _react.useState)([]);
  const [migrateFlyoutOpen, setMigrateFlyoutOpen] = (0, _react.useState)(false);
  const {
    allTags,
    agentsOnCurrentPage,
    agentsStatus,
    isLoading,
    nAgentsInTable,
    totalInactiveAgents,
    totalManagedAgentIds,
    managedAgentsOnCurrentPage,
    showUpgradeable,
    setShowUpgradeable,
    search,
    setSearch,
    selectedAgentPolicies,
    setSelectedAgentPolicies,
    sortField,
    setSortField,
    sortOrder,
    setSortOrder,
    selectedStatus,
    setSelectedStatus,
    selectedTags,
    setSelectedTags,
    allAgentPolicies,
    agentPoliciesRequest,
    agentPoliciesIndexedById,
    pagination,
    pageSizeOptions,
    setPagination,
    kuery,
    draftKuery,
    setDraftKuery,
    fetchData,
    currentRequestRef,
    latestAgentActionErrors,
    setLatestAgentActionErrors
  } = (0, _hooks2.useFetchAgentsData)();
  const onSubmitSearch = (0, _react.useCallback)(newKuery => {
    setSearch(newKuery);
    setPagination({
      ...pagination,
      currentPage: 1
    });
  }, [setSearch, pagination, setPagination]);
  const isUsingFilter = !!(search.trim() || selectedAgentPolicies.length || selectedStatus.length || selectedTags.length || showUpgradeable);
  const clearFilters = (0, _react.useCallback)(() => {
    setDraftKuery('');
    setSearch('');
    setSelectedAgentPolicies([]);
    setSelectedStatus([]);
    setSelectedTags([]);
    setShowUpgradeable(false);
  }, [setDraftKuery, setSearch, setSelectedAgentPolicies, setSelectedStatus, setSelectedTags, setShowUpgradeable]);
  const onTableChange = ({
    page,
    sort
  }) => {
    const newPagination = {
      ...pagination,
      currentPage: page.index + 1,
      pageSize: page.size
    };
    setPagination(newPagination);
    setSortField(sort.field);
    setSortOrder(sort.direction);
  };
  const openMigrateFlyout = agents => {
    const protectedAgents = agents.filter(agent => {
      var _agentPoliciesIndexed;
      return (_agentPoliciesIndexed = agentPoliciesIndexedById[agent.policy_id]) === null || _agentPoliciesIndexed === void 0 ? void 0 : _agentPoliciesIndexed.is_protected;
    });
    const fleetAgents = agents.filter(agent => {
      var _agentPoliciesIndexed2, _agentPoliciesIndexed3;
      return (_agentPoliciesIndexed2 = agentPoliciesIndexedById[agent.policy_id]) === null || _agentPoliciesIndexed2 === void 0 ? void 0 : (_agentPoliciesIndexed3 = _agentPoliciesIndexed2.package_policies) === null || _agentPoliciesIndexed3 === void 0 ? void 0 : _agentPoliciesIndexed3.some(p => {
        var _p$package;
        return ((_p$package = p.package) === null || _p$package === void 0 ? void 0 : _p$package.name) === _common.FLEET_SERVER_PACKAGE;
      });
    });
    const unallowedAgents = [...protectedAgents, ...fleetAgents];
    setProtectedAndFleetAgents(unallowedAgents);
    setAgentsToMigrate(agents.filter(agent => !unallowedAgents.some(a => a.id === agent.id)));
    setMigrateFlyoutOpen(true);
  };
  const renderActions = agent => {
    const agentPolicy = typeof agent.policy_id === 'string' ? agentPoliciesIndexedById[agent.policy_id] : undefined;

    // refreshing agent tags passed to TagsAddRemove component
    if ((agentToAddRemoveTags === null || agentToAddRemoveTags === void 0 ? void 0 : agentToAddRemoveTags.id) === agent.id && !(0, _lodash.isEqual)(agent.tags, agentToAddRemoveTags.tags)) {
      setAgentToAddRemoveTags(agent);
    }
    return /*#__PURE__*/_react.default.createElement(_components3.TableRowActions, {
      agent: agent,
      agentPolicy: agentPolicy,
      onReassignClick: () => setAgentToReassign(agent),
      onUnenrollClick: () => setAgentToUnenroll(agent),
      onUpgradeClick: () => setAgentToUpgrade(agent),
      onAddRemoveTagsClick: button => {
        setTagsPopoverButton(button);
        setAgentToAddRemoveTags(agent);
        setShowTagsAddRemove(!showTagsAddRemove);
      },
      onGetUninstallCommandClick: () => setAgentToGetUninstallCommand(agent),
      onRequestDiagnosticsClick: () => setAgentToRequestDiagnostics(agent),
      onMigrateAgentClick: () => openMigrateFlyout([agent])
    });
  };
  const isAgentSelectable = (0, _react.useCallback)(agent => {
    if (!agent.active) return false;
    if (!agent.policy_id) return true;
    const agentPolicy = agentPoliciesIndexedById[agent.policy_id];
    const isHosted = (agentPolicy === null || agentPolicy === void 0 ? void 0 : agentPolicy.is_managed) === true;
    return !isHosted;
  }, [agentPoliciesIndexedById]);
  const onSelectionChange = newAgents => {
    if (selectionMode === 'query' && newAgents.length < selectedAgents.length) {
      // differentiating between selection changed by agents dropping from current page or user action
      const areSelectedAgentsStillVisible = selectedAgents.length > 0 && (0, _lodash.differenceBy)(selectedAgents, agentsOnCurrentPage, 'id').length === 0;
      if (!areSelectedAgentsStillVisible) {
        // force selecting all agents on current page if staying in query mode
        return setSelectedAgents(agentsOnCurrentPage.filter(agent => isAgentSelectable(agent)));
      } else {
        setSelectionMode('manual');
      }
    }
    setSelectedAgents(newAgents);
  };
  const onSelectedStatusChange = status => {
    if (selectionMode === 'query') {
      setSelectionMode('manual');
    }
    setSelectedStatus(status);
  };
  const onSelectedAgentPoliciesChange = policies => {
    if (selectionMode === 'query') {
      setSelectionMode('manual');
    }
    setSelectedAgentPolicies(policies);
  };
  const agentToUnenrollHasFleetServer = (0, _react.useMemo)(() => {
    if (!agentToUnenroll || !agentToUnenroll.policy_id) {
      return false;
    }
    const agentPolicy = agentPoliciesIndexedById[agentToUnenroll.policy_id];
    if (!agentPolicy) {
      return false;
    }
    return (0, _services.policyHasFleetServer)(agentPolicy);
  }, [agentToUnenroll, agentPoliciesIndexedById]);

  // Missing Encryption key
  const [canShowMissingEncryptionKeyCallout, dismissEncryptionKeyCallout] = (0, _hooks2.useMissingEncryptionKeyCallout)();

  // Fleet server unhealthy status
  const {
    isUnhealthy: isFleetServerUnhealthy
  } = (0, _use_fleet_server_unhealthy.useFleetServerUnhealthy)();
  const {
    isFleetServerStandalone
  } = (0, _hooks.useFleetServerStandalone)();
  const showUnhealthyCallout = isFleetServerUnhealthy && !isFleetServerStandalone;
  const {
    shouldDisplayAgentSoftLimit
  } = (0, _hooks2.useAgentSoftLimit)();
  const onClickAddFleetServer = (0, _react.useCallback)(() => {
    flyoutContext.openFleetServerFlyout();
  }, [flyoutContext]);
  const onClickAgentActivity = (0, _react.useCallback)(() => {
    setAgentActivityFlyoutOpen(true);
    setLatestAgentActionErrors([]);
  }, [setAgentActivityFlyoutOpen, setLatestAgentActionErrors]);
  const refreshAgents = ({
    refreshTags = false
  } = {}) => {
    fetchData({
      refreshTags
    });
    setShowAgentActivityTour(true);
  };
  const isCurrentRequestIncremented = (currentRequestRef === null || currentRequestRef === void 0 ? void 0 : currentRequestRef.current) === 1;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isAgentActivityFlyoutOpen ? /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, null, /*#__PURE__*/_react.default.createElement(_agent_activity_flyout.AgentActivityFlyout, {
    onAbortSuccess: fetchData,
    onClose: () => setAgentActivityFlyoutOpen(false),
    openManageAutoUpgradeModal: policyId => {
      setSelectedPolicyId(policyId);
      setManageAutoUpgradeModalOpen(true);
    },
    refreshAgentActivity: isLoading,
    setSearch: setSearch,
    setSelectedStatus: setSelectedStatus
  })) : null, isManageAutoUpgradeModalOpen ? /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, null, /*#__PURE__*/_react.default.createElement(_manage_auto_upgrade_agents_modal.ManageAutoUpgradeAgentsModal, {
    key: selectedPolicyId,
    onClose: () => setManageAutoUpgradeModalOpen(false),
    agentPolicy: allAgentPolicies.find(p => p.id === selectedPolicyId)
  })) : null, enrollmentFlyout.isOpen ? /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, null, /*#__PURE__*/_react.default.createElement(_components.AgentEnrollmentFlyout, {
    agentPolicy: allAgentPolicies.find(p => p.id === enrollmentFlyout.selectedPolicyId),
    onClose: () => {
      setEnrollmentFlyoutState({
        isOpen: false
      });
      fetchData();
      agentPoliciesRequest.resendRequest();
    }
  })) : null, agentToReassign && /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, null, /*#__PURE__*/_react.default.createElement(_components2.AgentReassignAgentPolicyModal, {
    agents: [agentToReassign],
    onClose: () => {
      setAgentToReassign(undefined);
      refreshAgents();
    }
  })), agentToUnenroll && /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, null, /*#__PURE__*/_react.default.createElement(_components2.AgentUnenrollAgentModal, {
    agents: [agentToUnenroll],
    agentCount: 1,
    onClose: () => {
      setAgentToUnenroll(undefined);
      refreshAgents({
        refreshTags: true
      });
    },
    useForceUnenroll: agentToUnenroll.status === 'unenrolling',
    hasFleetServer: agentToUnenrollHasFleetServer
  })), (agentToGetUninstallCommand === null || agentToGetUninstallCommand === void 0 ? void 0 : agentToGetUninstallCommand.policy_id) && /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, null, /*#__PURE__*/_react.default.createElement(_components.UninstallCommandFlyout, {
    target: "agent",
    policyId: agentToGetUninstallCommand.policy_id,
    onClose: () => {
      setAgentToGetUninstallCommand(undefined);
      refreshAgents({
        refreshTags: true
      });
    }
  })), agentToUpgrade && /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, null, /*#__PURE__*/_react.default.createElement(_components2.AgentUpgradeAgentModal, {
    agents: [agentToUpgrade],
    agentCount: 1,
    onClose: () => {
      setAgentToUpgrade(undefined);
      refreshAgents();
    },
    isUpdating: (0, _agent_status.isStuckInUpdating)(agentToUpgrade)
  })), agentToRequestDiagnostics && /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, null, /*#__PURE__*/_react.default.createElement(_agent_request_diagnostics_modal.AgentRequestDiagnosticsModal, {
    agents: [agentToRequestDiagnostics],
    agentCount: 1,
    onClose: () => {
      setAgentToRequestDiagnostics(undefined);
    }
  })), showTagsAddRemove && /*#__PURE__*/_react.default.createElement(_components3.TagsAddRemove, {
    agentId: agentToAddRemoveTags === null || agentToAddRemoveTags === void 0 ? void 0 : agentToAddRemoveTags.id,
    allTags: allTags !== null && allTags !== void 0 ? allTags : [],
    selectedTags: (_agentToAddRemoveTags = agentToAddRemoveTags === null || agentToAddRemoveTags === void 0 ? void 0 : agentToAddRemoveTags.tags) !== null && _agentToAddRemoveTags !== void 0 ? _agentToAddRemoveTags : [],
    button: tagsPopoverButton,
    onTagsUpdated: tagsToAdd => {
      refreshAgents({
        refreshTags: true
      });
      // close popover if agent is going to disappear from view to prevent UI error
      if (tagsToAdd.length > 0 && (selectedTags[0] === 'No Tags' || kuery.includes('not tags:*'))) {
        setShowTagsAddRemove(false);
      }
    },
    onClosePopover: () => {
      setShowTagsAddRemove(false);
    }
  }), migrateFlyoutOpen && /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, null, /*#__PURE__*/_react.default.createElement(_components3.AgentMigrateFlyout, {
    agents: agentsToMigrate !== null && agentsToMigrate !== void 0 ? agentsToMigrate : [],
    protectedAndFleetAgents: protectedAndFleetAgents !== null && protectedAndFleetAgents !== void 0 ? protectedAndFleetAgents : [],
    onClose: () => {
      setAgentsToMigrate(undefined);
      setProtectedAndFleetAgents([]);
      setMigrateFlyoutOpen(false);
    },
    onSave: () => {
      setAgentsToMigrate(undefined);
      setProtectedAndFleetAgents([]);
      setMigrateFlyoutOpen(false);
      refreshAgents();
    }
  })), showUnhealthyCallout && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, cloud !== null && cloud !== void 0 && cloud.deploymentUrl ? /*#__PURE__*/_react.default.createElement(_components2.FleetServerCloudUnhealthyCallout, {
    deploymentUrl: cloud.deploymentUrl
  }) : /*#__PURE__*/_react.default.createElement(_components2.FleetServerOnPremUnhealthyCallout, {
    onClickAddFleetServer: onClickAddFleetServer
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  })), canShowMissingEncryptionKeyCallout && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_components2.FleetServerMissingEncryptionKeyCallout, {
    onClickHandler: dismissEncryptionKeyCallout
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  })), shouldDisplayAgentSoftLimit && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_components3.AgentSoftLimitCallout, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  })), /*#__PURE__*/_react.default.createElement(_components3.SearchAndFilterBar, {
    agentPolicies: allAgentPolicies,
    draftKuery: draftKuery,
    onDraftKueryChange: setDraftKuery,
    onSubmitSearch: onSubmitSearch,
    selectedAgentPolicies: selectedAgentPolicies,
    onSelectedAgentPoliciesChange: onSelectedAgentPoliciesChange,
    selectedStatus: selectedStatus,
    onSelectedStatusChange: onSelectedStatusChange,
    showUpgradeable: showUpgradeable,
    onShowUpgradeableChange: setShowUpgradeable,
    tags: allTags !== null && allTags !== void 0 ? allTags : [],
    selectedTags: selectedTags,
    onSelectedTagsChange: setSelectedTags,
    nAgentsInTable: nAgentsInTable,
    totalInactiveAgents: totalInactiveAgents,
    totalManagedAgentIds: totalManagedAgentIds,
    selectionMode: selectionMode,
    currentQuery: kuery,
    selectedAgents: selectedAgents,
    refreshAgents: refreshAgents,
    onClickAddAgent: () => setEnrollmentFlyoutState({
      isOpen: true
    }),
    onClickAddFleetServer: onClickAddFleetServer,
    agentsOnCurrentPage: agentsOnCurrentPage,
    onClickAgentActivity: onClickAgentActivity,
    shouldShowAgentActivityTour: showAgentActivityTour,
    latestAgentActionErrors: latestAgentActionErrors.length,
    sortField: sortField,
    sortOrder: sortOrder,
    onBulkMigrateClicked: agents => openMigrateFlyout(agents)
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_components3.AgentTableHeader, {
    totalAgents: nAgentsInTable,
    totalManagedAgents: totalManagedAgentIds.length || 0,
    agentStatus: agentsStatus,
    selectableAgents: (agentsOnCurrentPage === null || agentsOnCurrentPage === void 0 ? void 0 : agentsOnCurrentPage.filter(isAgentSelectable).length) || 0,
    managedAgentsOnCurrentPage: managedAgentsOnCurrentPage,
    selectionMode: selectionMode,
    setSelectionMode: setSelectionMode,
    selectedAgents: selectedAgents,
    setSelectedAgents: newAgents => {
      setSelectedAgents(newAgents);
      setSelectionMode('manual');
    },
    clearFilters: clearFilters,
    isUsingFilter: isUsingFilter
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_components3.AgentListTable, {
    agents: agentsOnCurrentPage,
    sortField: sortField,
    pageSizeOptions: pageSizeOptions,
    sortOrder: sortOrder,
    isLoading: isLoading,
    agentPoliciesIndexedById: agentPoliciesIndexedById,
    renderActions: renderActions,
    onSelectionChange: onSelectionChange,
    selected: selectedAgents,
    showUpgradeable: showUpgradeable,
    onTableChange: onTableChange,
    pagination: pagination,
    totalAgents: Math.min(nAgentsInTable, _constants.SO_SEARCH_LIMIT),
    isUsingFilter: isUsingFilter,
    setEnrollmentFlyoutState: setEnrollmentFlyoutState,
    clearFilters: clearFilters,
    isCurrentRequestIncremented: isCurrentRequestIncremented
  }));
};
exports.AgentListPage = AgentListPage;