"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAgentless = exports.isAgentlessSetupDefault = void 0;
exports.useSetupTechnology = useSetupTechnology;
var _react = require("react");
var _hooks = require("../../../../../hooks");
var _generate_new_agent_policy = require("../../../../../../../../common/services/generate_new_agent_policy");
var _types = require("../../../../../types");
var _components = require("../../components");
var _constants = require("../../../../../../../../common/constants");
var _agentless_policy_helper = require("../../../../../../../../common/services/agentless_policy_helper");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useAgentless = () => {
  var _config$agentless, _config$agentless2, _config$agentless3, _config$agentless3$cu;
  const config = (0, _hooks.useConfig)();
  const {
    cloud
  } = (0, _hooks.useStartServices)();
  const isServerless = !!(cloud !== null && cloud !== void 0 && cloud.isServerlessEnabled);
  const isCloud = !!(cloud !== null && cloud !== void 0 && cloud.isCloudEnabled);
  const isAgentlessEnabled = (isCloud || isServerless) && ((_config$agentless = config.agentless) === null || _config$agentless === void 0 ? void 0 : _config$agentless.enabled) === true;
  const isAgentlessDefault = isAgentlessEnabled && ((_config$agentless2 = config.agentless) === null || _config$agentless2 === void 0 ? void 0 : _config$agentless2.isDefault) === true;
  const isAgentlessCustomIntegrationsEnabled = isAgentlessEnabled && ((_config$agentless3 = config.agentless) === null || _config$agentless3 === void 0 ? void 0 : (_config$agentless3$cu = _config$agentless3.customIntegrations) === null || _config$agentless3$cu === void 0 ? void 0 : _config$agentless3$cu.enabled) === true;
  const isAgentlessAgentPolicy = agentPolicy => {
    if (!agentPolicy) return false;
    return isAgentlessEnabled && !!(agentPolicy !== null && agentPolicy !== void 0 && agentPolicy.supports_agentless);
  };

  // When an integration has at least a policy template enabled for agentless
  const isAgentlessIntegration = packageInfo => {
    var _packageInfo$installa;
    const installSource = packageInfo && 'installationInfo' in packageInfo && ((_packageInfo$installa = packageInfo.installationInfo) === null || _packageInfo$installa === void 0 ? void 0 : _packageInfo$installa.install_source);
    const isCustomIntegration = installSource === 'custom' || installSource === 'upload';
    if (isCustomIntegration && !isAgentlessCustomIntegrationsEnabled) {
      return false;
    }
    if (isAgentlessEnabled && (0, _agentless_policy_helper.isAgentlessIntegration)(packageInfo)) {
      return true;
    }
    return false;
  };
  return {
    isAgentlessEnabled,
    isAgentlessDefault,
    isAgentlessAgentPolicy,
    isAgentlessIntegration,
    isServerless,
    isCloud
  };
};
exports.useAgentless = useAgentless;
function useSetupTechnology({
  setNewAgentPolicy,
  newAgentPolicy,
  updatePackagePolicy,
  setSelectedPolicyTab,
  packageInfo,
  packagePolicy,
  isEditPage,
  agentPolicies,
  integrationToEnable,
  hideAgentlessSelector
}) {
  const {
    isAgentlessEnabled,
    isAgentlessDefault,
    isServerless,
    isCloud
  } = useAgentless();

  // this is a placeholder for the new agent-BASED policy that will be used when the user switches from agentless to agent-based and back
  const orginalAgentPolicyRef = (0, _react.useRef)({
    ...newAgentPolicy
  });
  const [currentAgentPolicy, setCurrentAgentPolicy] = (0, _react.useState)(newAgentPolicy);
  const allowedSetupTechnologies = (0, _react.useMemo)(() => {
    const setupTechnologies = [];
    if ((0, _agentless_policy_helper.isAgentlessIntegration)(packageInfo, integrationToEnable)) {
      setupTechnologies.push(_types.SetupTechnology.AGENTLESS);
    }
    if (!(0, _agentless_policy_helper.isOnlyAgentlessIntegration)(packageInfo, integrationToEnable)) {
      setupTechnologies.push(_types.SetupTechnology.AGENT_BASED);
    }
    return setupTechnologies;
  }, [integrationToEnable, packageInfo]);
  const [selectedSetupTechnology, setSelectedSetupTechnology] = (0, _react.useState)(_types.SetupTechnology.AGENT_BASED);
  // derive default setup technology based on package info and selected integration
  const [defaultSetupTechnology, setDefaultSetupTechnology] = (0, _react.useState)(_types.SetupTechnology.AGENT_BASED);
  (0, _react.useEffect)(() => {
    const shouldBeDefault = isAgentlessEnabled && !hideAgentlessSelector && ((0, _agentless_policy_helper.isOnlyAgentlessIntegration)(packageInfo, integrationToEnable) || isAgentlessSetupDefault(isAgentlessDefault, packageInfo, integrationToEnable)) ? _types.SetupTechnology.AGENTLESS : _types.SetupTechnology.AGENT_BASED;
    setDefaultSetupTechnology(shouldBeDefault);
    setSelectedSetupTechnology(shouldBeDefault);
  }, [isAgentlessEnabled, isAgentlessDefault, packageInfo, integrationToEnable, hideAgentlessSelector]);
  const agentlessPolicyName = (0, _agentless_policy_helper.getAgentlessAgentPolicyNameFromPackagePolicyName)(packagePolicy.name);
  const [agentlessPolicyOutputId, setAgentlessPolicyOutputId] = (0, _react.useState)();
  const [agentlessPolicyFleetServerHostId, setAgentlessPolicyFleetServerHostId] = (0, _react.useState)();
  (0, _react.useEffect)(() => {
    const fetchOutputId = async () => {
      const outputId = isServerless ? _constants.SERVERLESS_DEFAULT_OUTPUT_ID : isCloud ? _constants.DEFAULT_OUTPUT_ID : undefined;
      if (outputId) {
        var _outputData$data;
        const outputData = await (0, _hooks.sendGetOneOutput)(outputId);
        setAgentlessPolicyOutputId((_outputData$data = outputData.data) !== null && _outputData$data !== void 0 && _outputData$data.item ? outputId : undefined);
      } else {
        setAgentlessPolicyOutputId(undefined);
      }
    };
    const fetchFleetServerHostId = async () => {
      const hostId = isServerless ? _constants.SERVERLESS_DEFAULT_FLEET_SERVER_HOST_ID : isCloud ? _constants.DEFAULT_FLEET_SERVER_HOST_ID : undefined;
      if (hostId) {
        var _hostData$data;
        const hostData = await (0, _hooks.sendGetOneFleetServerHost)(hostId);
        setAgentlessPolicyFleetServerHostId((_hostData$data = hostData.data) !== null && _hostData$data !== void 0 && _hostData$data.item ? hostId : undefined);
      } else {
        setAgentlessPolicyFleetServerHostId(undefined);
      }
    };
    fetchOutputId();
    fetchFleetServerHostId();
  }, [isCloud, isServerless]);
  const handleSetupTechnologyChange = (0, _react.useCallback)(setupTechnology => {
    if (!isAgentlessEnabled || setupTechnology === selectedSetupTechnology) {
      return;
    }
    setSelectedPolicyTab(_components.SelectedPolicyTab.NEW);
    setSelectedSetupTechnology(setupTechnology);
  }, [isAgentlessEnabled, selectedSetupTechnology, setSelectedPolicyTab, setSelectedSetupTechnology]);
  if (isEditPage && agentPolicies && agentPolicies.some(policy => policy.supports_agentless) && selectedSetupTechnology === _types.SetupTechnology.AGENT_BASED) {
    setSelectedSetupTechnology(_types.SetupTechnology.AGENTLESS);
  }
  if (!isEditPage && packagePolicy && isAgentlessEnabled && selectedSetupTechnology === _types.SetupTechnology.AGENTLESS && (!currentAgentPolicy.supports_agentless || agentlessPolicyName !== currentAgentPolicy.name)) {
    const nextNewAgentlessPolicy = {
      ...(0, _generate_new_agent_policy.generateNewAgentPolicyWithDefaults)({
        inactivity_timeout: _constants.AGENTLESS_AGENT_POLICY_INACTIVITY_TIMEOUT,
        supports_agentless: true,
        monitoring_enabled: _constants.AGENTLESS_AGENT_POLICY_MONITORING,
        ...(agentlessPolicyOutputId ? {
          data_output_id: agentlessPolicyOutputId
        } : {}),
        ...(agentlessPolicyFleetServerHostId ? {
          fleet_server_host_id: agentlessPolicyFleetServerHostId
        } : {})
      }),
      name: agentlessPolicyName,
      global_data_tags: (0, _agentless_policy_helper.getAgentlessGlobalDataTags)(packageInfo)
    };
    const agentlessPolicy = getAgentlessPolicy(packageInfo);
    if (agentlessPolicy) {
      nextNewAgentlessPolicy.agentless = agentlessPolicy;
    }
    setCurrentAgentPolicy(nextNewAgentlessPolicy);
    setNewAgentPolicy(nextNewAgentlessPolicy);
    updatePackagePolicy({
      supports_agentless: true
    });
  }
  if (!isEditPage && selectedSetupTechnology === _types.SetupTechnology.AGENT_BASED && (currentAgentPolicy.supports_agentless || packagePolicy.supports_agentless)) {
    const nextNewAgentlessPolicy = {
      ...orginalAgentPolicyRef.current,
      supports_agentless: false
    };
    setCurrentAgentPolicy(nextNewAgentlessPolicy);
    setNewAgentPolicy(nextNewAgentlessPolicy);
    updatePackagePolicy({
      supports_agentless: false
    });
  }
  return {
    handleSetupTechnologyChange,
    allowedSetupTechnologies,
    selectedSetupTechnology,
    defaultSetupTechnology
  };
}
const isAgentlessSetupDefault = (isAgentlessDefault, packageInfo, integrationToEnable) => {
  var _packageInfo$policy_t, _policyTemplates$find, _policyTemplates$find2, _policyTemplates$find3;
  const policyTemplates = (_packageInfo$policy_t = packageInfo === null || packageInfo === void 0 ? void 0 : packageInfo.policy_templates) !== null && _packageInfo$policy_t !== void 0 ? _packageInfo$policy_t : [];
  if (policyTemplates.length === 0) {
    return false;
  }
  const hasDefaultAgentlessIntegration = integrationToEnable && ((_policyTemplates$find = policyTemplates.find(p => p.name === integrationToEnable)) === null || _policyTemplates$find === void 0 ? void 0 : (_policyTemplates$find2 = _policyTemplates$find.deployment_modes) === null || _policyTemplates$find2 === void 0 ? void 0 : (_policyTemplates$find3 = _policyTemplates$find2.agentless) === null || _policyTemplates$find3 === void 0 ? void 0 : _policyTemplates$find3.is_default);
  if (hasDefaultAgentlessIntegration) {
    return true;
  }
  const allPolicyTemplatesAreDefaultAgentless = policyTemplates.every(template => {
    var _template$deployment_, _template$deployment_2;
    return (_template$deployment_ = template.deployment_modes) === null || _template$deployment_ === void 0 ? void 0 : (_template$deployment_2 = _template$deployment_.agentless) === null || _template$deployment_2 === void 0 ? void 0 : _template$deployment_2.is_default;
  });
  if (allPolicyTemplatesAreDefaultAgentless) {
    return true;
  }
  if (isAgentlessDefault) {
    const allPolicyTemplatesHaveAgentlessDefined = policyTemplates.every(template => {
      var _template$deployment_3;
      return (_template$deployment_3 = template.deployment_modes) === null || _template$deployment_3 === void 0 ? void 0 : _template$deployment_3.agentless;
    });
    if (allPolicyTemplatesHaveAgentlessDefined) {
      return true;
    }
  }
  return false;
};
exports.isAgentlessSetupDefault = isAgentlessSetupDefault;
const getAgentlessPolicy = packageInfo => {
  var _packageInfo$policy_t2, _agentlessPolicyTempl;
  if (!(packageInfo !== null && packageInfo !== void 0 && packageInfo.policy_templates) && !(packageInfo !== null && packageInfo !== void 0 && (_packageInfo$policy_t2 = packageInfo.policy_templates) !== null && _packageInfo$policy_t2 !== void 0 && _packageInfo$policy_t2.some(policy => policy.deployment_modes))) {
    return;
  }
  const agentlessPolicyTemplate = packageInfo.policy_templates.find(policy => policy.deployment_modes);

  // assumes that all the policy templates agentless deployments modes indentify have the same organization, division and team
  const agentlessInfo = agentlessPolicyTemplate === null || agentlessPolicyTemplate === void 0 ? void 0 : (_agentlessPolicyTempl = agentlessPolicyTemplate.deployment_modes) === null || _agentlessPolicyTempl === void 0 ? void 0 : _agentlessPolicyTempl.agentless;
  if (!(agentlessInfo !== null && agentlessInfo !== void 0 && agentlessInfo.resources)) {
    return;
  }
  return {
    resources: agentlessInfo.resources
  };
};