"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LastUpdated = LastUpdated;
var _react = _interopRequireWildcard(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _use_series_storage = require("../hooks/use_series_storage");
var _chart_creation_info = require("./chart_creation_info");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function LastUpdated() {
  const {
    chartTimeRangeContext
  } = (0, _use_series_storage.useSeriesStorage)();
  const {
    lastUpdated
  } = chartTimeRangeContext || {};
  const [refresh, setRefresh] = (0, _react.useState)(() => Date.now());
  (0, _react.useEffect)(() => {
    const interVal = setInterval(() => {
      setRefresh(Date.now());
    }, 5000);
    return () => {
      clearInterval(interVal);
    };
  }, []);
  (0, _react.useEffect)(() => {
    setRefresh(Date.now());
  }, [lastUpdated]);
  if (!lastUpdated) {
    return null;
  }
  const isWarning = (0, _moment.default)().diff((0, _moment.default)(lastUpdated), 'minute') > 5;
  const isDanger = (0, _moment.default)().diff((0, _moment.default)(lastUpdated), 'minute') > 10;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: /*#__PURE__*/_react.default.createElement(_chart_creation_info.ChartCreationInfo, chartTimeRangeContext)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "info"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: isDanger ? 'danger' : isWarning ? 'warning' : 'subdued',
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.exploratoryView.expView.lastUpdated.label",
    defaultMessage: "Last Updated: {updatedDate}",
    values: {
      updatedDate: (0, _moment.default)(lastUpdated).from(refresh)
    }
  }))));
}