"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.chatPromptFactory = exports.DEFAULT_ASSISTANT_GRAPH_PROMPT_TEMPLATE = void 0;
var _prompts = require("@langchain/core/prompts");
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
var _enrich_graph_input_messages = require("../../utils/enrich_graph_input_messages");
var _prompts2 = require("../../../prompt/prompts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_ASSISTANT_GRAPH_PROMPT_TEMPLATE = exports.DEFAULT_ASSISTANT_GRAPH_PROMPT_TEMPLATE = _prompts.ChatPromptTemplate.fromMessages([['system', '{systemPrompt}'], new _prompts.MessagesPlaceholder('messages')]);
const KNOWLEDGE_HISTORY_PREFIX = 'Knowledge History:';
const NO_KNOWLEDGE_HISTORY = '[No existing knowledge history]';
const formatKnowledgeHistory = knowledgeHistory => {
  return knowledgeHistory.length ? `${KNOWLEDGE_HISTORY_PREFIX}\n${knowledgeHistory.map(e => e.text).join('\n')}` : NO_KNOWLEDGE_HISTORY;
};

/**
 * Factory that creates a ChatPromptValueInterface from a ChatPromptTemplate with the given inputs.
 * This should be used to create the initial messages state for the graph.
 */
const chatPromptFactory = async (chatPromptTemplate, inputs) => {
  var _inputs$kbClient$getR, _inputs$kbClient, _inputs$contentRefere, _inputs$formattedTime;
  const knowledgeHistoryPromise = (_inputs$kbClient$getR = (_inputs$kbClient = inputs.kbClient) === null || _inputs$kbClient === void 0 ? void 0 : _inputs$kbClient.getRequiredKnowledgeBaseDocumentEntries()) !== null && _inputs$kbClient$getR !== void 0 ? _inputs$kbClient$getR : Promise.resolve([]);
  const knowledgeHistory = await knowledgeHistoryPromise;
  const citedKnowledgeHistory = knowledgeHistory.map((0, _elasticAssistantCommon.enrichDocument)(inputs.contentReferencesStore));
  const formattedKnowledgeHistory = formatKnowledgeHistory(citedKnowledgeHistory);
  const templatedSystemPrompt = inputs.additionalPrompt ? `${inputs.prompt}\n\n${inputs.additionalPrompt}` : inputs.prompt;
  const systemPromptTemplate = _prompts.PromptTemplate.fromTemplate(templatedSystemPrompt);
  const systemPrompt = await systemPromptTemplate.format({
    citations_prompt: (_inputs$contentRefere = inputs.contentReferencesStore.options) !== null && _inputs$contentRefere !== void 0 && _inputs$contentRefere.disabled ? '' : _prompts2.INCLUDE_CITATIONS,
    formattedTime: (_inputs$formattedTime = inputs.formattedTime) !== null && _inputs$formattedTime !== void 0 ? _inputs$formattedTime : '',
    knowledgeHistory: formattedKnowledgeHistory
  });
  const enrichedMessages = await (0, _enrich_graph_input_messages.enrichConversation)({
    actionsClient: inputs.actionsClient,
    savedObjectsClient: inputs.savedObjectsClient,
    connectorId: inputs.connectorId,
    llmType: inputs.llmType,
    messages: inputs.conversationMessages
  });
  const chatPrompt = await chatPromptTemplate.invoke({
    systemPrompt,
    messages: enrichedMessages
  });
  return chatPrompt;
};
exports.chatPromptFactory = chatPromptFactory;