"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAllLogsDataViewSpec = exports.ALL_LOGS_DATA_VIEW_ID = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const ALL_LOGS_DATA_VIEW_ID = exports.ALL_LOGS_DATA_VIEW_ID = 'discover-observability-solution-all-logs';
const getAllLogsDataViewSpec = ({
  allLogsIndexPattern
}) => ({
  id: ALL_LOGS_DATA_VIEW_ID,
  name: _i18n.i18n.translate('discover.observabilitySolution.allLogsDataViewName', {
    defaultMessage: 'All logs'
  }),
  title: allLogsIndexPattern,
  timeFieldName: '@timestamp'
});
exports.getAllLogsDataViewSpec = getAllLogsDataViewSpec;