"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getStateDefaults = getStateDefaults;
var _lodash = require("lodash");
var _unifiedHistogram = require("@kbn/unified-histogram");
var _discoverUtils = require("@kbn/discover-utils");
var _esQuery = require("@kbn/es-query");
var _get_valid_view_mode = require("../../utils/get_valid_view_mode");
var _data_sources = require("../../../../../common/data_sources");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function getDefaultColumns(savedSearch, uiSettings) {
  if (savedSearch !== null && savedSearch !== void 0 && savedSearch.columns && savedSearch.columns.length > 0) {
    return [...savedSearch.columns];
  }
  return [...uiSettings.get(_discoverUtils.DEFAULT_COLUMNS_SETTING)];
}
function getStateDefaults({
  savedSearch,
  overrideDataView,
  services
}) {
  var _savedSearch$sort;
  const searchSource = savedSearch === null || savedSearch === void 0 ? void 0 : savedSearch.searchSource;
  const {
    data,
    uiSettings,
    storage
  } = services;
  const dataView = overrideDataView !== null && overrideDataView !== void 0 ? overrideDataView : searchSource === null || searchSource === void 0 ? void 0 : searchSource.getField('index');
  const query = (searchSource === null || searchSource === void 0 ? void 0 : searchSource.getField('query')) || data.query.queryString.getDefaultQuery();
  const isEsqlQuery = (0, _esQuery.isOfAggregateQueryType)(query);
  const sort = (0, _discoverUtils.getSortArray)((_savedSearch$sort = savedSearch === null || savedSearch === void 0 ? void 0 : savedSearch.sort) !== null && _savedSearch$sort !== void 0 ? _savedSearch$sort : [], dataView, isEsqlQuery);
  const columns = getDefaultColumns(savedSearch, uiSettings);
  const chartHidden = (0, _unifiedHistogram.getChartHidden)(storage, 'discover');
  const dataSource = isEsqlQuery ? (0, _data_sources.createEsqlDataSource)() : dataView !== null && dataView !== void 0 && dataView.id ? (0, _data_sources.createDataViewDataSource)({
    dataViewId: dataView.id
  }) : undefined;
  const defaultState = {
    query,
    sort: !sort.length ? (0, _discoverUtils.getDefaultSort)(dataView, uiSettings.get(_discoverUtils.SORT_DEFAULT_ORDER_SETTING, 'desc'), uiSettings.get(_discoverUtils.DOC_HIDE_TIME_COLUMN_SETTING, false), isEsqlQuery) : sort,
    columns,
    dataSource,
    interval: 'auto',
    filters: (0, _lodash.cloneDeep)(searchSource === null || searchSource === void 0 ? void 0 : searchSource.getOwnField('filter')),
    hideChart: chartHidden,
    viewMode: undefined,
    hideAggregatedPreview: undefined,
    savedQuery: undefined,
    rowHeight: undefined,
    headerRowHeight: undefined,
    rowsPerPage: undefined,
    sampleSize: undefined,
    grid: undefined,
    breakdownField: undefined,
    density: undefined
  };
  if (savedSearch !== null && savedSearch !== void 0 && savedSearch.grid) {
    defaultState.grid = savedSearch.grid;
  }
  if ((savedSearch === null || savedSearch === void 0 ? void 0 : savedSearch.hideChart) !== undefined) {
    defaultState.hideChart = savedSearch.hideChart;
  }
  if ((savedSearch === null || savedSearch === void 0 ? void 0 : savedSearch.rowHeight) !== undefined) {
    defaultState.rowHeight = savedSearch.rowHeight;
  }
  if ((savedSearch === null || savedSearch === void 0 ? void 0 : savedSearch.headerRowHeight) !== undefined) {
    defaultState.headerRowHeight = savedSearch.headerRowHeight;
  }
  if (savedSearch !== null && savedSearch !== void 0 && savedSearch.viewMode) {
    defaultState.viewMode = (0, _get_valid_view_mode.getValidViewMode)({
      viewMode: savedSearch.viewMode,
      isEsqlMode: isEsqlQuery
    });
  }
  if (savedSearch !== null && savedSearch !== void 0 && savedSearch.hideAggregatedPreview) {
    defaultState.hideAggregatedPreview = savedSearch.hideAggregatedPreview;
  }
  if (savedSearch !== null && savedSearch !== void 0 && savedSearch.rowsPerPage) {
    defaultState.rowsPerPage = savedSearch.rowsPerPage;
  }
  if (savedSearch !== null && savedSearch !== void 0 && savedSearch.sampleSize) {
    defaultState.sampleSize = savedSearch.sampleSize;
  }
  if (savedSearch !== null && savedSearch !== void 0 && savedSearch.breakdownField) {
    defaultState.breakdownField = savedSearch.breakdownField;
  }
  if (savedSearch !== null && savedSearch !== void 0 && savedSearch.density) {
    defaultState.density = savedSearch.density;
  }
  return defaultState;
}