"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ImportSettings = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _simple = require("./simple");
var _advanced = require("./advanced");
var _kibana_context = require("../../../kibana_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ImportSettings = ({
  index,
  dataView,
  initialized,
  onIndexChange,
  createDataView,
  onCreateDataViewChange,
  onDataViewChange,
  indexSettingsString,
  mappingsString,
  pipelineString,
  onIndexSettingsStringChange,
  onMappingsStringChange,
  onPipelineStringChange,
  indexNameError,
  dataViewNameError,
  combinedFields,
  onCombinedFieldsChange,
  results
}) => {
  const {
    services: {
      application: {
        capabilities
      }
    }
  } = (0, _kibana_context.useDataVisualizerKibana)();
  const canCreateDataView = capabilities.savedObjectsManagement.edit === true || capabilities.indexPatterns.save === true;
  const tabs = [{
    id: 'simple-settings',
    name: _i18n.i18n.translate('xpack.dataVisualizer.file.importSettings.simpleTabName', {
      defaultMessage: 'Simple'
    }),
    content: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_simple.SimpleSettings, {
      index: index,
      initialized: initialized,
      onIndexChange: onIndexChange,
      createDataView: createDataView,
      onCreateDataViewChange: onCreateDataViewChange,
      indexNameError: indexNameError,
      combinedFields: combinedFields,
      canCreateDataView: canCreateDataView,
      results: results
    }))
  }, {
    id: 'advanced-settings',
    name: _i18n.i18n.translate('xpack.dataVisualizer.file.importSettings.advancedTabName', {
      defaultMessage: 'Advanced'
    }),
    content: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_advanced.AdvancedSettings, {
      index: index,
      dataView: dataView,
      initialized: initialized,
      onIndexChange: onIndexChange,
      createDataView: createDataView,
      onCreateDataViewChange: onCreateDataViewChange,
      onDataViewChange: onDataViewChange,
      indexSettingsString: indexSettingsString,
      mappingsString: mappingsString,
      pipelineString: pipelineString,
      onIndexSettingsStringChange: onIndexSettingsStringChange,
      onMappingsStringChange: onMappingsStringChange,
      onPipelineStringChange: onPipelineStringChange,
      indexNameError: indexNameError,
      dataViewNameError: dataViewNameError,
      combinedFields: combinedFields,
      onCombinedFieldsChange: onCombinedFieldsChange,
      results: results,
      canCreateDataView: canCreateDataView
    }))
  }];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTabbedContent, {
    tabs: tabs,
    initialSelectedTab: tabs[0],
    onTabClick: () => {}
  }));
};
exports.ImportSettings = ImportSettings;