"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CombinedFieldsForm = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _geo_point = require("./geo_point");
var _semantic_text = require("./semantic_text");
var _combined_field_label = require("./combined_field_label");
var _utils = require("./utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class CombinedFieldsForm extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      isPopoverOpen: false
    });
    (0, _defineProperty2.default)(this, "togglePopover", () => {
      this.setState(prevState => ({
        isPopoverOpen: !prevState.isPopoverOpen
      }));
    });
    (0, _defineProperty2.default)(this, "closePopover", () => {
      this.setState({
        isPopoverOpen: false
      });
    });
    (0, _defineProperty2.default)(this, "addCombinedField", (combinedField, addToMappings, addToPipeline) => {
      const mappings = this.parseMappings();
      const pipeline = this.parsePipeline();
      const newMappings = addToMappings(mappings);
      const newPipeline = addToPipeline(pipeline);
      this.props.onMappingsStringChange(JSON.stringify(newMappings, null, 2));
      this.props.onPipelineStringChange(JSON.stringify(newPipeline, null, 2));
      this.props.onCombinedFieldsChange([...this.props.combinedFields, combinedField]);
      this.closePopover();
    });
    (0, _defineProperty2.default)(this, "removeCombinedField", index => {
      let mappings;
      let pipeline;
      try {
        mappings = this.parseMappings();
        pipeline = this.parsePipeline();
      } catch (error) {
        // how should remove error be surfaced?
        return;
      }
      const updatedCombinedFields = [...this.props.combinedFields];
      const removedCombinedFields = updatedCombinedFields.splice(index, 1);
      this.props.onMappingsStringChange(JSON.stringify((0, _utils.removeCombinedFieldsFromMappings)(mappings, removedCombinedFields), null, 2));
      this.props.onPipelineStringChange(JSON.stringify((0, _utils.removeCombinedFieldsFromPipeline)(pipeline, removedCombinedFields), null, 2));
      this.props.onCombinedFieldsChange(updatedCombinedFields);
    });
    (0, _defineProperty2.default)(this, "hasNameCollision", name => {
      var _this$props$results$c;
      if ((_this$props$results$c = this.props.results.column_names) !== null && _this$props$results$c !== void 0 && _this$props$results$c.includes(name)) {
        // collision with column name
        return true;
      }
      if (this.props.combinedFields.some(combinedField => combinedField.combinedFieldName === name)) {
        // collision with combined field name
        return true;
      }
      const mappings = this.parseMappings();
      return Object.hasOwn(mappings.properties, name);
    });
  }
  parseMappings() {
    try {
      return JSON.parse(this.props.mappingsString);
    } catch (error) {
      throw new Error(_i18n.i18n.translate('xpack.dataVisualizer.combinedFieldsForm.mappingsParseError', {
        defaultMessage: 'Error parsing mappings: {error}',
        values: {
          error: error.message
        }
      }));
    }
  }
  parsePipeline() {
    try {
      if (this.props.pipelineString === '') {
        return {
          description: '',
          processors: []
        };
      }
      return JSON.parse(this.props.pipelineString);
    } catch (error) {
      throw new Error(_i18n.i18n.translate('xpack.dataVisualizer.combinedFieldsForm.pipelineParseError', {
        defaultMessage: 'Error parsing pipeline: {error}',
        values: {
          error: error.message
        }
      }));
    }
  }
  render() {
    const geoPointLabel = _i18n.i18n.translate('xpack.dataVisualizer.file.geoPointForm.combinedFieldLabel', {
      defaultMessage: 'Add geo point field'
    });
    const semanticTextLabel = _i18n.i18n.translate('xpack.dataVisualizer.file.semanticTextForm.combinedFieldLabel', {
      defaultMessage: 'Add semantic text field'
    });
    const panels = [{
      id: 0,
      items: [{
        name: geoPointLabel,
        panel: 1
      }, {
        name: semanticTextLabel,
        panel: 2
      }]
    }, {
      id: 1,
      title: geoPointLabel,
      content: /*#__PURE__*/_react.default.createElement(_geo_point.GeoPointForm, {
        addCombinedField: this.addCombinedField,
        hasNameCollision: this.hasNameCollision,
        results: this.props.results
      })
    }, {
      id: 2,
      title: semanticTextLabel,
      content: /*#__PURE__*/_react.default.createElement(_semantic_text.SemanticTextForm, {
        addCombinedField: this.addCombinedField,
        hasNameCollision: this.hasNameCollision,
        results: this.props.results
      })
    }];
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _i18n.i18n.translate('xpack.dataVisualizer.combinedFieldsLabel', {
        defaultMessage: 'Automatically created fields'
      })
    }, /*#__PURE__*/_react.default.createElement("div", null, this.props.combinedFields.map((combinedField, idx) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      key: idx,
      gutterSize: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_combined_field_label.CombinedFieldLabel, {
      combinedField: combinedField
    })), !this.props.isDisabled && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      iconType: "trash",
      color: "danger",
      onClick: this.removeCombinedField.bind(null, idx),
      title: _i18n.i18n.translate('xpack.dataVisualizer.removeCombinedFieldsLabel', {
        defaultMessage: 'Remove combined field'
      }),
      "aria-label": _i18n.i18n.translate('xpack.dataVisualizer.removeCombinedFieldsLabel', {
        defaultMessage: 'Remove combined field'
      })
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      id: "combineFieldsPopover",
      button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        onClick: this.togglePopover,
        size: "xs",
        iconType: "plusInCircleFilled",
        isDisabled: this.props.isDisabled
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.dataVisualizer.addCombinedFieldsLabel",
        defaultMessage: "Add additional field"
      })),
      isOpen: this.state.isPopoverOpen,
      closePopover: this.closePopover,
      anchorPosition: "rightCenter"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
      initialPanelId: 0,
      panels: panels
    }))));
  }
}
exports.CombinedFieldsForm = CombinedFieldsForm;