"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.FindingsVulnerabilityFlyoutHeader = void 0;
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _cloudSecurityPosture = require("@kbn/cloud-security-posture");
var _i18nReact = require("@kbn/i18n-react");
var _test_subjects = require("../../test_subjects");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EMPTY_VALUE = '-';
const FindingsVulnerabilityFlyoutHeader = ({
  finding
}) => {
  var _finding$observer, _vulnerability$score, _vulnerability$score2, _vulnerability$data_s, _vulnerability$data_s2, _vulnerability$data_s3;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const vulnerability = finding === null || finding === void 0 ? void 0 : finding.vulnerability;
  const vendor = finding === null || finding === void 0 ? void 0 : (_finding$observer = finding.observer) === null || _finding$observer === void 0 ? void 0 : _finding$observer.vendor;
  const renderCveBadge = () => {
    if (Array.isArray(vulnerability === null || vulnerability === void 0 ? void 0 : vulnerability.id) && (vulnerability === null || vulnerability === void 0 ? void 0 : vulnerability.id.length) > 1) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        "data-test-subj": _test_subjects.VULNERABILITY_HEADER_CVE_BADGE,
        color: "accent",
        css: (0, _react2.css)`
              border-radius: ${euiTheme.border.radius.small};
            `
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.csp.vulnerabilities.vulnerabilityFindingFlyout.cveTooltip",
        defaultMessage: "{value} More",
        values: {
          value: (vulnerability === null || vulnerability === void 0 ? void 0 : vulnerability.id.length) - 1
        }
      })));
    }
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
  };
  const renderCves = () => {
    if (!(vulnerability !== null && vulnerability !== void 0 && vulnerability.id) || (vulnerability === null || vulnerability === void 0 ? void 0 : vulnerability.id.length) === 0) {
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
    }
    const renderVulnerabilityId = () => {
      const id = Array.isArray(vulnerability.id) ? vulnerability.id[0] : vulnerability.id;
      const references = Array.isArray(vulnerability.reference) ? vulnerability.reference : [vulnerability.reference];
      const referenceLink = (0, _cloudSecurityPosture.findReferenceLink)(references, id);
      return referenceLink ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": _test_subjects.VULNERABILITY_HEADER_REFERENCE_LINK,
        href: referenceLink,
        target: "_blank",
        color: "primary",
        css: (0, _react2.css)`
              display: flex;
              align-items: center;
              svg {
                width: ${euiTheme.base}px;
                height: ${euiTheme.base}px;
              }
            `
      }, id)) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        "data-test-subj": _test_subjects.VULNERABILITY_HEADER_ID
      }, id);
    };
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "flexStart",
      alignItems: "center",
      gutterSize: "xs",
      responsive: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s",
      css: (0, _react2.css)`
              font-weight: ${euiTheme.font.weight.semiBold};
              line-height: ${euiTheme.size.xl};
            `
    }, renderVulnerabilityId())), renderCveBadge());
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    css: (0, _react2.css)`
          gap: ${euiTheme.size.s};
        `
  }, renderCves()), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": _test_subjects.VULNERABILITY_SCORES_FLYOUT
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    borderRadius: "none",
    paddingSize: "xl",
    css: {
      borderRight: 'solid 1px #D3DAE6',
      padding: '12px'
    },
    hasBorder: false,
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement("b", null, "CVSS")), vulnerability !== null && vulnerability !== void 0 && vulnerability.score ? /*#__PURE__*/_react.default.createElement(_cloudSecurityPosture.CVSScoreBadge, {
    version: vulnerability === null || vulnerability === void 0 ? void 0 : (_vulnerability$score = vulnerability.score) === null || _vulnerability$score === void 0 ? void 0 : _vulnerability$score.version,
    score: vulnerability === null || vulnerability === void 0 ? void 0 : (_vulnerability$score2 = vulnerability.score) === null || _vulnerability$score2 === void 0 ? void 0 : _vulnerability$score2.base
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, EMPTY_VALUE)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": _test_subjects.DATA_SOURCE_VULNERABILITY_FLYOUT
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    borderRadius: "none",
    paddingSize: "xl",
    css: {
      borderRight: 'solid 1px #D3DAE6',
      padding: '12px'
    },
    hasBorder: false,
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement("b", null, "Data source"), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), vulnerability !== null && vulnerability !== void 0 && (_vulnerability$data_s = vulnerability.data_source) !== null && _vulnerability$data_s !== void 0 && _vulnerability$data_s.URL ? /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: (_vulnerability$data_s2 = vulnerability.data_source) === null || _vulnerability$data_s2 === void 0 ? void 0 : _vulnerability$data_s2.URL,
    target: "_blank"
  }, vulnerability === null || vulnerability === void 0 ? void 0 : (_vulnerability$data_s3 = vulnerability.data_source) === null || _vulnerability$data_s3 === void 0 ? void 0 : _vulnerability$data_s3.ID) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, EMPTY_VALUE))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    borderRadius: "none",
    paddingSize: "xl",
    css: {
      padding: '12px'
    },
    hasBorder: false,
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement("b", null, "Vendor")), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, " ", vendor, " ")))))))), /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
          margin: ${euiTheme.size.s};
        `
  }));
};

// eslint-disable-next-line import/no-default-export
exports.FindingsVulnerabilityFlyoutHeader = FindingsVulnerabilityFlyoutHeader;
var _default = exports.default = FindingsVulnerabilityFlyoutHeader;