"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchDetectionRulesByTags = exports.fetchDetectionRulesByTags = exports.DETECTION_ENGINE_RULES_URL_FIND = void 0;
var _public = require("@kbn/kibana-react-plugin/public");
var _reactQuery = require("@tanstack/react-query");
var _cloudSecurityPostureCommon = require("@kbn/cloud-security-posture-common");
var _constants = require("../constants");
var _detection_rules = require("../../../common/utils/detection_rules");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DETECTION_ENGINE_URL = '/api/detection_engine';
const DETECTION_ENGINE_RULES_URL = `${DETECTION_ENGINE_URL}/rules`;
const DETECTION_ENGINE_RULES_URL_FIND = exports.DETECTION_ENGINE_RULES_URL_FIND = `${DETECTION_ENGINE_RULES_URL}/_find`;
const useFetchDetectionRulesByTags = (tags, option = {
  match: 'all'
}) => {
  const {
    http
  } = (0, _public.useKibana)().services;
  return (0, _reactQuery.useQuery)({
    queryKey: [_constants.DETECTION_ENGINE_RULES_KEY, tags, option],
    queryFn: () => fetchDetectionRulesByTags(tags, option, http),
    enabled: tags.length > 0
  });
};
exports.useFetchDetectionRulesByTags = useFetchDetectionRulesByTags;
const fetchDetectionRulesByTags = (tags, option = {
  match: 'all'
}, http) => {
  const query = {
    page: 1,
    per_page: 1,
    filter: option.match === 'all' ? (0, _detection_rules.convertRuleTagsToMatchAllKQL)(tags) : (0, _detection_rules.convertRuleTagsToMatchAnyKQL)(tags)
  };
  return http.fetch(DETECTION_ENGINE_RULES_URL_FIND, {
    method: 'GET',
    version: _cloudSecurityPostureCommon.DETECTION_RULE_RULES_API_CURRENT_VERSION,
    query
  });
};
exports.fetchDetectionRulesByTags = fetchDetectionRulesByTags;