"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getV1 = void 0;
var _i18n = require("@kbn/i18n");
var _saved_objects = require("@kbn/files-plugin/server/saved_objects");
var _server = require("@kbn/core/server");
var _common = require("@kbn/features-plugin/common");
var _constants = require("../../common/constants");
var _common2 = require("../../common");
var _constants2 = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * The order of appearance in the feature privilege page
 * under the management section. Cases should be under
 * the Actions and Connectors feature
 */

const FEATURE_ORDER = 3100;
const getV1 = () => {
  const capabilities = (0, _common2.createUICapabilities)();
  const apiTags = (0, _common2.getApiTags)(_constants.APP_ID);
  return {
    deprecated: {
      notice: _i18n.i18n.translate('xpack.cases.features.casesFeature.deprecationMessage', {
        defaultMessage: 'The {currentId} permissions are deprecated, please see {casesFeatureIdV2}.',
        values: {
          currentId: _constants.FEATURE_ID,
          casesFeatureIdV2: _constants.FEATURE_ID_V3
        }
      })
    },
    id: _constants.FEATURE_ID,
    name: _i18n.i18n.translate('xpack.cases.features.casesFeatureNameDeprecated', {
      defaultMessage: 'Cases (Deprecated)'
    }),
    category: _server.DEFAULT_APP_CATEGORIES.management,
    scope: [_common.KibanaFeatureScope.Spaces, _common.KibanaFeatureScope.Security],
    app: [],
    order: FEATURE_ORDER,
    management: {
      insightsAndAlerting: [_constants.APP_ID]
    },
    cases: [_constants.APP_ID],
    privileges: {
      all: {
        api: [...apiTags.all, ...apiTags.createComment],
        cases: {
          create: [_constants.APP_ID],
          read: [_constants.APP_ID],
          update: [_constants.APP_ID],
          push: [_constants.APP_ID],
          createComment: [_constants.APP_ID],
          reopenCase: [_constants.APP_ID],
          assign: [_constants.APP_ID]
        },
        management: {
          insightsAndAlerting: [_constants.APP_ID]
        },
        savedObject: {
          all: [..._saved_objects.hiddenTypes],
          read: [..._saved_objects.hiddenTypes]
        },
        ui: [...capabilities.all, ...capabilities.createComment, ...capabilities.reopenCase, ...capabilities.assignCase],
        replacedBy: {
          default: [{
            feature: _constants.FEATURE_ID_V3,
            privileges: ['all']
          }],
          minimal: [{
            feature: _constants.FEATURE_ID_V3,
            privileges: ['minimal_all', 'create_comment', 'case_reopen', 'cases_assign']
          }]
        }
      },
      read: {
        api: apiTags.read,
        cases: {
          read: [_constants.APP_ID]
        },
        management: {
          insightsAndAlerting: [_constants.APP_ID]
        },
        savedObject: {
          all: [],
          read: [..._saved_objects.hiddenTypes]
        },
        ui: capabilities.read,
        replacedBy: {
          default: [{
            feature: _constants.FEATURE_ID_V3,
            privileges: ['read']
          }],
          minimal: [{
            feature: _constants.FEATURE_ID_V3,
            privileges: ['minimal_read']
          }]
        }
      }
    },
    subFeatures: [{
      name: _i18n.i18n.translate('xpack.cases.features.deleteSubFeatureName', {
        defaultMessage: 'Delete'
      }),
      privilegeGroups: [{
        groupType: 'independent',
        privileges: [{
          api: apiTags.delete,
          id: _constants2.CASES_DELETE_SUB_PRIVILEGE_ID,
          name: _i18n.i18n.translate('xpack.cases.features.deleteSubFeatureDetails', {
            defaultMessage: 'Delete cases and comments'
          }),
          includeIn: 'all',
          savedObject: {
            all: [..._saved_objects.hiddenTypes],
            read: [..._saved_objects.hiddenTypes]
          },
          cases: {
            delete: [_constants.APP_ID]
          },
          ui: capabilities.delete,
          replacedBy: [{
            feature: _constants.FEATURE_ID_V3,
            privileges: [_constants2.CASES_DELETE_SUB_PRIVILEGE_ID]
          }]
        }]
      }]
    }, {
      name: _i18n.i18n.translate('xpack.cases.features.casesSettingsSubFeatureName', {
        defaultMessage: 'Case settings'
      }),
      privilegeGroups: [{
        groupType: 'independent',
        privileges: [{
          id: _constants2.CASES_SETTINGS_SUB_PRIVILEGE_ID,
          name: _i18n.i18n.translate('xpack.cases.features.casesSettingsSubFeatureDetails', {
            defaultMessage: 'Edit case settings'
          }),
          includeIn: 'all',
          savedObject: {
            all: [..._saved_objects.hiddenTypes],
            read: [..._saved_objects.hiddenTypes]
          },
          cases: {
            settings: [_constants.APP_ID]
          },
          ui: capabilities.settings,
          replacedBy: [{
            feature: _constants.FEATURE_ID_V3,
            privileges: [_constants2.CASES_SETTINGS_SUB_PRIVILEGE_ID]
          }]
        }]
      }]
    }]
  };
};
exports.getV1 = getV1;