"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useUpdateComment = void 0;
var _reactQuery = require("@tanstack/react-query");
var _use_cases_toast = require("../common/use_cases_toast");
var _use_cases_context = require("../components/cases_context/use_cases_context");
var _use_on_refresh_case_view_page = require("../components/case_view/use_on_refresh_case_view_page");
var _api = require("./api");
var _constants = require("./constants");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useUpdateComment = () => {
  const {
    showErrorToast
  } = (0, _use_cases_toast.useCasesToast)();
  const refreshCaseViewPage = (0, _use_on_refresh_case_view_page.useRefreshCaseViewPage)();
  // this hook guarantees that there will be at least one value in the owner array, we'll
  // just use the first entry just in case there are more than one entry
  const owner = (0, _use_cases_context.useCasesContext)().owner[0];
  return (0, _reactQuery.useMutation)(({
    caseId,
    commentId,
    commentUpdate,
    version
  }) => (0, _api.patchComment)({
    caseId,
    commentId,
    commentUpdate,
    version,
    owner
  }), {
    mutationKey: _constants.casesMutationsKeys.updateComment,
    onSuccess: () => {
      refreshCaseViewPage();
    },
    onError: error => {
      showErrorToast(error, {
        title: i18n.ERROR_TITLE
      });
    }
  });
};
exports.useUpdateComment = useUpdateComment;