"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAllCasesState = useAllCasesState;
var _react = require("react");
var _reactRouterDom = require("react-router-dom");
var _reactFastCompare = _interopRequireDefault(require("react-fast-compare"));
var _lodash = require("lodash");
var _constants = require("../../containers/constants");
var _constants2 = require("../../../common/constants");
var _stringify_url_params = require("./utils/stringify_url_params");
var _all_cases_url_state_deserializer = require("./utils/all_cases_url_state_deserializer");
var _all_cases_url_state_serializer = require("./utils/all_cases_url_state_serializer");
var _parse_url_params = require("./utils/parse_url_params");
var _sanitize_state = require("./utils/sanitize_state");
var _use_get_case_configuration = require("../../containers/configure/use_get_case_configuration");
var _use_cases_local_storage = require("../../common/use_cases_local_storage");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useAllCasesState(isModalView = false) {
  const isStateLoadedFromLocalStorage = (0, _react.useRef)(false);
  const isFirstRun = (0, _react.useRef)(false);
  const [tableState, setTableState] = (0, _react.useState)(_constants.DEFAULT_CASES_TABLE_STATE);
  const [urlState, setUrlState] = useAllCasesUrlState();
  const [localStorageState, setLocalStorageState] = useAllCasesLocalStorage();
  const {
    isFetching: isLoadingCasesConfiguration
  } = (0, _use_get_case_configuration.useGetCaseConfiguration)();
  const allCasesTableState = (0, _react.useMemo)(() => isModalView ? tableState : getAllCasesTableState(urlState, localStorageState), [isModalView, tableState, urlState, localStorageState]);
  const setState = (0, _react.useCallback)(state => {
    if (isModalView) {
      setTableState(state);
      return;
    }
    if (!(0, _reactFastCompare.default)(state, urlState)) {
      setUrlState(state);
    }
    if (!(0, _reactFastCompare.default)(state, localStorageState)) {
      setLocalStorageState(state);
    }
  }, [localStorageState, urlState, isModalView, setLocalStorageState, setUrlState]);

  // use of useEffect because setUrlState calls history.push
  (0, _react.useEffect)(() => {
    if (!isStateLoadedFromLocalStorage.current && isURLStateEmpty(urlState) && localStorageState && !isModalView) {
      setUrlState(localStorageState, 'replace');
      isStateLoadedFromLocalStorage.current = true;
    }
  }, [localStorageState, setUrlState, urlState, isModalView]);

  /**
   * When navigating for the first time in a URL
   * we need to persist the state on the local storage.
   * We need to do it only on the first run and only when the URL is not empty.
   * Otherwise we may introduce a race condition or loop with the above hook.
   */
  if (!isFirstRun.current && !isURLStateEmpty(urlState) && localStorageState && !(0, _reactFastCompare.default)(allCasesTableState, localStorageState) && !isLoadingCasesConfiguration && !isModalView) {
    setLocalStorageState(allCasesTableState);
    isFirstRun.current = true;
  }
  return {
    ...allCasesTableState,
    setQueryParams: newQueryParams => {
      setState({
        filterOptions: allCasesTableState.filterOptions,
        queryParams: {
          ...allCasesTableState.queryParams,
          ...newQueryParams
        }
      });
    },
    setFilterOptions: newFilterOptions => {
      setState({
        filterOptions: {
          ...allCasesTableState.filterOptions,
          ...newFilterOptions
        },
        queryParams: allCasesTableState.queryParams
      });
    }
  };
}
const useAllCasesUrlState = () => {
  const history = (0, _reactRouterDom.useHistory)();
  const location = (0, _reactRouterDom.useLocation)();
  const {
    data: {
      customFields: customFieldsConfiguration
    }
  } = (0, _use_get_case_configuration.useGetCaseConfiguration)();
  const urlParams = (0, _parse_url_params.parseUrlParams)(new URLSearchParams(decodeURIComponent(location.search)));
  const parsedUrlParams = (0, _all_cases_url_state_deserializer.allCasesUrlStateDeserializer)(urlParams, customFieldsConfiguration);
  const updateQueryParams = (0, _react.useCallback)((updated, mode = 'push') => {
    const updatedQuery = (0, _all_cases_url_state_serializer.allCasesUrlStateSerializer)(updated);
    const search = (0, _stringify_url_params.stringifyUrlParams)(updatedQuery, location.search);
    history[mode]({
      ...location,
      search
    });
  }, [history, location]);
  return [parsedUrlParams, updateQueryParams];
};
const getAllCasesTableState = (urlState, localStorageState) => {
  if (isURLStateEmpty(urlState)) {
    return {
      queryParams: {
        ..._constants.DEFAULT_CASES_TABLE_STATE.queryParams,
        ...(localStorageState === null || localStorageState === void 0 ? void 0 : localStorageState.queryParams)
      },
      filterOptions: {
        ..._constants.DEFAULT_CASES_TABLE_STATE.filterOptions,
        ...(localStorageState === null || localStorageState === void 0 ? void 0 : localStorageState.filterOptions)
      }
    };
  }
  return {
    queryParams: {
      ..._constants.DEFAULT_CASES_TABLE_STATE.queryParams,
      ...urlState.queryParams
    },
    filterOptions: {
      ..._constants.DEFAULT_CASES_TABLE_STATE.filterOptions,
      ...urlState.filterOptions
    }
  };
};
const isURLStateEmpty = urlState => {
  if ((0, _lodash.isEmpty)(urlState)) {
    return true;
  }
  if ((0, _lodash.isEmpty)(urlState.filterOptions) && (0, _lodash.isEmpty)(urlState.queryParams)) {
    return true;
  }
  return false;
};
const useAllCasesLocalStorage = () => {
  const [state, setState] = (0, _use_cases_local_storage.useCasesLocalStorage)(_constants2.LOCAL_STORAGE_KEYS.casesTableState, {
    queryParams: _constants.DEFAULT_QUERY_PARAMS,
    filterOptions: _constants.DEFAULT_FILTER_OPTIONS
  });
  const sanitizedState = (0, _sanitize_state.sanitizeState)(state);
  return [{
    queryParams: {
      ..._constants.DEFAULT_CASES_TABLE_STATE.queryParams,
      ...sanitizedState.queryParams
    },
    filterOptions: {
      ..._constants.DEFAULT_CASES_TABLE_STATE.filterOptions,
      ...sanitizedState.filterOptions
    }
  }, setState];
};