"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDestinationParentIds = getDestinationParentIds;
exports.getExitSpans = getExitSpans;
exports.getSourceSpanIds = getSourceSpanIds;
var _server = require("@kbn/observability-plugin/server");
var _common = require("@kbn/observability-plugin/common");
var _utils = require("@kbn/apm-data-access-plugin/server/utils");
var _apmTypes = require("@kbn/apm-types");
var _as_mutable_array = require("../../../../common/utils/as_mutable_array");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getExitSpans({
  apmEventClient,
  start,
  end,
  destinationNode,
  parentSpans
}) {
  var _response$aggregation, _response$aggregation2, _response$aggregation3, _response$aggregation4, _response$aggregation5;
  const requiredFields = (0, _as_mutable_array.asMutableArray)([_apmTypes.SERVICE_NAME, _apmTypes.SPAN_ID, _apmTypes.TRACE_ID, _apmTypes.TRANSACTION_ID, _apmTypes.SPAN_NAME, _apmTypes.SERVICE_NODE_NAME, _apmTypes.AGENT_NAME, _apmTypes.PARENT_ID]);
  const parentSpanIds = Array.from(parentSpans.keys());
  const response = await apmEventClient.search('diagnostics_get_exit_spans_from_source_node', {
    apm: {
      events: [_common.ProcessorEvent.transaction]
    },
    track_total_hits: false,
    size: 0,
    query: {
      bool: {
        filter: [...(0, _server.rangeQuery)(start, end), ...(0, _server.termsQuery)(_apmTypes.PARENT_ID, ...parentSpanIds)]
      }
    },
    aggs: {
      matching_destination_resources: {
        filter: {
          term: {
            [_apmTypes.SERVICE_NAME]: destinationNode
          }
        },
        aggs: {
          sample_docs: {
            top_hits: {
              size: 50,
              fields: [...requiredFields]
            }
          }
        }
      }
    }
  });
  const apmExitSpans = ((_response$aggregation = response === null || response === void 0 ? void 0 : (_response$aggregation2 = response.aggregations) === null || _response$aggregation2 === void 0 ? void 0 : (_response$aggregation3 = _response$aggregation2.matching_destination_resources) === null || _response$aggregation3 === void 0 ? void 0 : (_response$aggregation4 = _response$aggregation3.sample_docs) === null || _response$aggregation4 === void 0 ? void 0 : (_response$aggregation5 = _response$aggregation4.hits) === null || _response$aggregation5 === void 0 ? void 0 : _response$aggregation5.hits.map(doc => {
    var _fields$parent, _fields$parent2, _fields$service, _fields$span$id, _fields$span, _fields$transaction$i, _fields$transaction, _fields$service$node$, _fields$service2, _fields$service2$node, _fields$trace$id, _fields$trace, _fields$agent$name, _fields$agent;
    const fields = (0, _utils.unflattenKnownApmEventFields)(doc === null || doc === void 0 ? void 0 : doc.fields);
    if (!(fields !== null && fields !== void 0 && (_fields$parent = fields.parent) !== null && _fields$parent !== void 0 && _fields$parent.id) || !parentSpans.get(fields === null || fields === void 0 ? void 0 : (_fields$parent2 = fields.parent) === null || _fields$parent2 === void 0 ? void 0 : _fields$parent2.id)) {
      return;
    }
    return {
      destinationService: fields === null || fields === void 0 ? void 0 : (_fields$service = fields.service) === null || _fields$service === void 0 ? void 0 : _fields$service.name,
      spanId: (_fields$span$id = fields === null || fields === void 0 ? void 0 : (_fields$span = fields.span) === null || _fields$span === void 0 ? void 0 : _fields$span.id) !== null && _fields$span$id !== void 0 ? _fields$span$id : '',
      transactionId: (_fields$transaction$i = fields === null || fields === void 0 ? void 0 : (_fields$transaction = fields.transaction) === null || _fields$transaction === void 0 ? void 0 : _fields$transaction.id) !== null && _fields$transaction$i !== void 0 ? _fields$transaction$i : '',
      serviceNodeName: (_fields$service$node$ = fields === null || fields === void 0 ? void 0 : (_fields$service2 = fields.service) === null || _fields$service2 === void 0 ? void 0 : (_fields$service2$node = _fields$service2.node) === null || _fields$service2$node === void 0 ? void 0 : _fields$service2$node.name) !== null && _fields$service$node$ !== void 0 ? _fields$service$node$ : '',
      traceId: (_fields$trace$id = fields === null || fields === void 0 ? void 0 : (_fields$trace = fields.trace) === null || _fields$trace === void 0 ? void 0 : _fields$trace.id) !== null && _fields$trace$id !== void 0 ? _fields$trace$id : '',
      agentName: (_fields$agent$name = fields === null || fields === void 0 ? void 0 : (_fields$agent = fields.agent) === null || _fields$agent === void 0 ? void 0 : _fields$agent.name) !== null && _fields$agent$name !== void 0 ? _fields$agent$name : ''
    };
  })) !== null && _response$aggregation !== void 0 ? _response$aggregation : []).filter(span => !!span);
  return {
    apmExitSpans,
    totalConnections: apmExitSpans.length,
    rawResponse: response,
    hasMatchingDestinationResources: apmExitSpans.length > 0
  };
}
async function getSourceSpanIds({
  apmEventClient,
  start,
  end,
  sourceNode,
  traceIds
}) {
  var _response$aggregation6, _response$aggregation7, _response$aggregation8, _response$aggregation9;
  const requiredFields = (0, _as_mutable_array.asMutableArray)([_apmTypes.SPAN_ID]);
  const optionalFields = (0, _as_mutable_array.asMutableArray)([_apmTypes.SPAN_DESTINATION_SERVICE_RESOURCE]);
  const response = await apmEventClient.search('diagnostics_get_source_node_span_samples', {
    apm: {
      events: [_common.ProcessorEvent.span]
    },
    track_total_hits: false,
    size: 0,
    query: {
      bool: {
        filter: [...(0, _server.rangeQuery)(start, end), ...(0, _server.termsQuery)(_apmTypes.TRACE_ID, ...traceIds)]
      }
    },
    aggs: {
      sample_docs: {
        composite: {
          size: 1000,
          sources: (0, _as_mutable_array.asMutableArray)([{
            serviceName: {
              terms: {
                field: _apmTypes.SERVICE_NAME
              }
            }
          }, {
            spanName: {
              terms: {
                field: _apmTypes.SPAN_NAME
              }
            }
          }])
        },
        aggs: {
          top_span_ids: {
            top_hits: {
              size: 10,
              fields: [...requiredFields, ...optionalFields]
            }
          }
        }
      }
    }
  });
  const destinationsBySpanId = new Map();
  return {
    sourceSpanIdsRawResponse: response,
    destinationsBySpanId: (_response$aggregation6 = (_response$aggregation7 = response.aggregations) === null || _response$aggregation7 === void 0 ? void 0 : (_response$aggregation8 = _response$aggregation7.sample_docs) === null || _response$aggregation8 === void 0 ? void 0 : (_response$aggregation9 = _response$aggregation8.buckets) === null || _response$aggregation9 === void 0 ? void 0 : _response$aggregation9.reduce((acc, bucket) => {
      var _event$span, _event$span$destinati, _event$span$destinati2;
      const event = (0, _utils.unflattenKnownApmEventFields)(bucket.top_span_ids.hits.hits[0].fields, requiredFields);
      acc.set(event.span.id, (_event$span = event.span) === null || _event$span === void 0 ? void 0 : (_event$span$destinati = _event$span.destination) === null || _event$span$destinati === void 0 ? void 0 : (_event$span$destinati2 = _event$span$destinati.service) === null || _event$span$destinati2 === void 0 ? void 0 : _event$span$destinati2.resource);
      return acc;
    }, destinationsBySpanId)) !== null && _response$aggregation6 !== void 0 ? _response$aggregation6 : destinationsBySpanId
  };
}
async function getDestinationParentIds({
  apmEventClient,
  start,
  end,
  parentSpans,
  destinationNode
}) {
  const parentSpanIds = Array.from(parentSpans.keys());
  const response = await apmEventClient.search('diagnostics_get_destination_node_parent_ids', {
    apm: {
      events: [_common.ProcessorEvent.transaction]
    },
    track_total_hits: false,
    size: 1,
    query: {
      bool: {
        filter: [...(0, _server.rangeQuery)(start, end), ...(parentSpanIds ? (0, _server.termsQuery)(_apmTypes.PARENT_ID, ...parentSpanIds) : []), ...(0, _server.termQuery)(_apmTypes.SERVICE_NAME, destinationNode)]
      }
    },
    aggs: {
      sample_docs: {
        top_hits: {
          size: 5,
          fields: [_apmTypes.PARENT_ID, _apmTypes.SERVICE_NAME, _apmTypes.SPAN_DESTINATION_SERVICE_RESOURCE]
        }
      }
    }
  });
  return {
    rawResponse: response,
    hasParent: response.hits.hits.length > 0
  };
}