"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.withDiagnoseButton = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// This HOC wraps a component and adds a diagnose button at the bottom if showDiagnoseButton is true.
const withDiagnoseButton = WrappedComponent => {
  function ComponentWithDiagnoseButton(props) {
    const {
      showDiagnoseButton,
      onDiagnoseClick,
      ...rest
    } = props;
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(WrappedComponent, rest), showDiagnoseButton && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
      margin: "s"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      color: "subdued",
      hasBorder: false,
      paddingSize: "m"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "none",
      responsive: false,
      direction: "column"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "crossInCircle",
      color: "warning",
      size: "m"
    }), ' ', /*#__PURE__*/_react.default.createElement("strong", null, _i18n.i18n.translate('xpack.apm.serviceMap.diagnosisTitle', {
      defaultMessage: 'Missing connection?'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "aria-label": _i18n.i18n.translate('xpack.apm.componentWithDiagnoseButton.diagnosethisconnectionButton.ariaLabel', {
        defaultMessage: 'Diagnose this connection'
      }),
      "data-test-subj": "diagnose-connection-button",
      onClick: onDiagnoseClick,
      size: "s"
    }, _i18n.i18n.translate('xpack.apm.serviceMap.diagnoseConnectionButtonText', {
      defaultMessage: 'Open diagnostic tool'
    }))))))));
  }
  return ComponentWithDiagnoseButton;
};
exports.withDiagnoseButton = withDiagnoseButton;