"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRulesSettingsFeature = getRulesSettingsFeature;
var _i18n = require("@kbn/i18n");
var _server = require("@kbn/core/server");
var _common = require("@kbn/features-plugin/common");
var _common2 = require("../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getRulesSettingsFeature(isServerless) {
  const settings = {
    id: _common2.RULES_SETTINGS_FEATURE_ID,
    name: _i18n.i18n.translate('xpack.alerting.feature.rulesSettingsFeatureName', {
      defaultMessage: 'Rules Settings'
    }),
    category: _server.DEFAULT_APP_CATEGORIES.management,
    scope: [_common.KibanaFeatureScope.Spaces, _common.KibanaFeatureScope.Security],
    app: [],
    management: {
      insightsAndAlerting: ['triggersActions']
    },
    privileges: {
      all: {
        app: [],
        api: [],
        management: {
          insightsAndAlerting: ['triggersActions']
        },
        savedObject: {
          all: [_common2.RULES_SETTINGS_SAVED_OBJECT_TYPE],
          read: []
        },
        ui: ['show', 'save']
      },
      read: {
        app: [],
        api: [],
        management: {
          insightsAndAlerting: ['triggersActions']
        },
        savedObject: {
          all: [],
          read: [_common2.RULES_SETTINGS_SAVED_OBJECT_TYPE]
        },
        ui: ['show']
      }
    },
    subFeatures: [{
      name: _i18n.i18n.translate('xpack.alerting.feature.flappingSettingsSubFeatureName', {
        defaultMessage: 'Flapping detection'
      }),
      privilegeGroups: [{
        groupType: 'mutually_exclusive',
        privileges: [{
          api: [_common2.API_PRIVILEGES.READ_FLAPPING_SETTINGS, _common2.API_PRIVILEGES.WRITE_FLAPPING_SETTINGS],
          name: 'All',
          id: _common2.ALL_FLAPPING_SETTINGS_SUB_FEATURE_ID,
          includeIn: 'all',
          savedObject: {
            all: [_common2.RULES_SETTINGS_SAVED_OBJECT_TYPE],
            read: []
          },
          ui: ['writeFlappingSettingsUI', 'readFlappingSettingsUI']
        }, {
          api: [_common2.API_PRIVILEGES.READ_FLAPPING_SETTINGS],
          name: 'Read',
          id: _common2.READ_FLAPPING_SETTINGS_SUB_FEATURE_ID,
          includeIn: 'read',
          savedObject: {
            all: [],
            read: [_common2.RULES_SETTINGS_SAVED_OBJECT_TYPE]
          },
          ui: ['readFlappingSettingsUI']
        }]
      }]
    }, {
      name: _i18n.i18n.translate('xpack.alerting.feature.alertDeleteSettingsSubFeatureName', {
        defaultMessage: 'Alert deletion'
      }),
      privilegeGroups: [{
        groupType: 'mutually_exclusive',
        privileges: [{
          api: [_common2.API_PRIVILEGES.READ_ALERT_DELETE_SETTINGS, _common2.API_PRIVILEGES.WRITE_ALERT_DELETE_SETTINGS],
          name: 'All',
          id: _common2.ALL_ALERT_DELETE_SETTINGS_SUB_FEATURE_ID,
          includeIn: 'all',
          savedObject: {
            all: [_common2.RULES_SETTINGS_SAVED_OBJECT_TYPE],
            read: []
          },
          ui: ['writeAlertDeleteSettingsUI', 'readAlertDeleteSettingsUI']
        }, {
          api: [_common2.API_PRIVILEGES.READ_ALERT_DELETE_SETTINGS],
          name: 'Read',
          id: _common2.READ_ALERT_DELETE_SETTINGS_SUB_FEATURE_ID,
          includeIn: 'read',
          savedObject: {
            all: [],
            read: [_common2.RULES_SETTINGS_SAVED_OBJECT_TYPE]
          },
          ui: ['readAlertDeleteSettingsUI']
        }]
      }]
    }]
  };
  if (isServerless) {
    settings.subFeatures.push({
      name: _i18n.i18n.translate('xpack.alerting.feature.queryDelaySettingsSubFeatureName', {
        defaultMessage: 'Query delay'
      }),
      privilegeGroups: [{
        groupType: 'mutually_exclusive',
        privileges: [{
          api: [_common2.API_PRIVILEGES.READ_QUERY_DELAY_SETTINGS, _common2.API_PRIVILEGES.WRITE_QUERY_DELAY_SETTINGS],
          name: 'All',
          id: _common2.ALL_QUERY_DELAY_SETTINGS_SUB_FEATURE_ID,
          includeIn: 'all',
          savedObject: {
            all: [_common2.RULES_SETTINGS_SAVED_OBJECT_TYPE],
            read: []
          },
          ui: ['writeQueryDelaySettingsUI', 'readQueryDelaySettingsUI']
        }, {
          api: [_common2.API_PRIVILEGES.READ_QUERY_DELAY_SETTINGS],
          name: 'Read',
          id: _common2.READ_QUERY_DELAY_SETTINGS_SUB_FEATURE_ID,
          includeIn: 'read',
          savedObject: {
            all: [],
            read: [_common2.RULES_SETTINGS_SAVED_OBJECT_TYPE]
          },
          ui: ['readQueryDelaySettingsUI']
        }]
      }]
    });
  }
  return settings;
}