"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AIAssistantManagementSelectionPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _server = require("@kbn/core/server");
var _common = require("@kbn/features-plugin/common");
var _managementSettingsIds = require("@kbn/management-settings-ids");
var _configSchema = require("@kbn/config-schema");
var _ui_setting_keys = require("../common/ui_setting_keys");
var _constants = require("../common/constants");
var _classic_setting = require("./src/settings/classic_setting");
var _observability_setting = require("./src/settings/observability_setting");
var _security_setting = require("./src/settings/security_setting");
var _ai_assistant_type = require("../common/ai_assistant_type");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class AIAssistantManagementSelectionPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "config", void 0);
    this.config = initializerContext.config.get();
  }
  setup(core, plugins) {
    var _plugins$features;
    (_plugins$features = plugins.features) === null || _plugins$features === void 0 ? void 0 : _plugins$features.registerKibanaFeature({
      id: 'aiAssistantManagementSelection',
      name: _i18n.i18n.translate('aiAssistantManagementSelection.featureRegistry.featureName', {
        defaultMessage: 'AI Assistant'
      }),
      order: 8600,
      app: [],
      category: _server.DEFAULT_APP_CATEGORIES.management,
      scope: [_common.KibanaFeatureScope.Spaces, _common.KibanaFeatureScope.Security],
      management: {
        kibana: ['aiAssistantManagementSelection', 'securityAiAssistantManagement', 'observabilityAiAssistantManagement']
      },
      minimumLicense: 'enterprise',
      privileges: {
        all: {
          management: {
            kibana: ['aiAssistantManagementSelection', 'securityAiAssistantManagement', 'observabilityAiAssistantManagement']
          },
          savedObject: {
            all: [],
            read: []
          },
          ui: []
        },
        read: {
          management: {
            kibana: ['aiAssistantManagementSelection', 'securityAiAssistantManagement', 'observabilityAiAssistantManagement']
          },
          savedObject: {
            all: [],
            read: []
          },
          ui: []
        }
      }
    });
    this.registerUiSettings(core, plugins);
    return {};
  }
  registerUiSettings(core, plugins) {
    var _this$config$preferre;
    core.uiSettings.register({
      [_managementSettingsIds.GEN_AI_SETTINGS_DEFAULT_AI_CONNECTOR]: {
        readonlyMode: 'ui',
        readonly: false,
        schema: _configSchema.schema.string(),
        value: _constants.NO_DEFAULT_CONNECTOR
      }
    });
    core.uiSettings.register({
      [_managementSettingsIds.GEN_AI_SETTINGS_DEFAULT_AI_CONNECTOR_DEFAULT_ONLY]: {
        readonlyMode: 'ui',
        readonly: false,
        schema: _configSchema.schema.boolean(),
        value: false
      }
    });
    core.capabilities.registerProvider(() => {
      return {
        management: {
          kibana: {
            aiAssistantManagementSelection: true,
            observabilityAiAssistantManagement: true,
            securityAiAssistantManagement: true
          }
        }
      };
    });
    const {
      cloud
    } = plugins;
    const serverlessProjectType = cloud === null || cloud === void 0 ? void 0 : cloud.serverless.projectType;
    switch (serverlessProjectType) {
      case 'observability':
        core.uiSettings.register({
          [_ui_setting_keys.PREFERRED_AI_ASSISTANT_TYPE_SETTING_KEY]: {
            ..._observability_setting.observabilitySolutionSetting,
            value: this.config.preferredAIAssistantType
          }
        });
        return;
      case 'security':
        core.uiSettings.register({
          [_ui_setting_keys.PREFERRED_AI_ASSISTANT_TYPE_SETTING_KEY]: {
            ..._security_setting.securitySolutionSetting,
            value: this.config.preferredAIAssistantType
          }
        });
        return;
      // TODO: Add another case for search with the correct copy of the setting.
      // see: https://github.com/elastic/kibana/issues/227695
      default:
        // This case is hit when in stateful Kibana
        return core.uiSettings.register({
          [_ui_setting_keys.PREFERRED_AI_ASSISTANT_TYPE_SETTING_KEY]: {
            ..._classic_setting.classicSetting,
            value: (_this$config$preferre = this.config.preferredAIAssistantType) !== null && _this$config$preferre !== void 0 ? _this$config$preferre : _ai_assistant_type.AIAssistantType.Default
          }
        });
    }
  }
  start(core) {
    return {};
  }
  stop() {}
}
exports.AIAssistantManagementSelectionPlugin = AIAssistantManagementSelectionPlugin;