"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getControlledBy = getControlledBy;
exports.mapEmbeddableFactory = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _eui = require("@elastic/eui");
var _public = require("@kbn/data-plugin/public");
var _public2 = require("@kbn/embeddable-plugin/public");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _rxjs = require("rxjs");
var _publishes_settings = require("@kbn/presentation-containers/interfaces/publishes_settings");
var _constants = require("../../common/constants");
var _embeddable = require("../../common/embeddable");
var _map_page = require("../routes/map_page");
var _initialize_redux_sync = require("./initialize_redux_sync");
var _library_transforms = require("./library_transforms");
var _kibana_services = require("../kibana_services");
var _initialize_action_handlers = require("./initialize_action_handlers");
var _map_container = require("../connected_components/map_container");
var _wait_until_time_layers_load = require("../routes/map_page/map_app/wait_until_time_layers_load");
var _initialize_cross_panel_actions = require("./initialize_cross_panel_actions");
var _initialize_data_views = require("./initialize_data_views");
var _initialize_fetch = require("./initialize_fetch");
var _initialize_edit_api = require("./initialize_edit_api");
var _references = require("../../common/migrations/references");
var _types = require("./map_renderer/types");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getControlledBy(id) {
  return `mapEmbeddablePanel${id}`;
}
const mapEmbeddableFactory = exports.mapEmbeddableFactory = {
  type: _constants.MAP_SAVED_OBJECT_TYPE,
  deserializeState: state => {
    var _state$references;
    return state.rawState ? (0, _embeddable.inject)(state.rawState, (_state$references = state.references) !== null && _state$references !== void 0 ? _state$references : []) : {};
  },
  buildEmbeddable: async (state, buildApi, uuid, parentApi) => {
    var _getEmbeddableEnhance, _dynamicActionsApi$dy, _dynamicActionsApi$dy2;
    const savedMap = new _map_page.SavedMap({
      mapSerializedState: state
    });
    await savedMap.whenReady();
    const attributes$ = new _rxjs.BehaviorSubject(state.attributes);
    const mapSettings$ = new _rxjs.BehaviorSubject(state.mapSettings);
    const savedObjectId$ = new _rxjs.BehaviorSubject(state.savedObjectId);

    // eslint bug, eslint thinks api is never reassigned even though it is
    // eslint-disable-next-line prefer-const
    let api;
    const getApi = () => api;
    const sharingSavedObjectProps = savedMap.getSharingSavedObjectProps();
    const spaces = (0, _kibana_services.getSpacesApi)();
    const controlledBy = getControlledBy(uuid);
    const titleManager = (0, _presentationPublishing.initializeTitleManager)(state);
    const timeRange = (0, _presentationPublishing.initializeTimeRange)(state);
    const dynamicActionsApi = (_getEmbeddableEnhance = (0, _kibana_services.getEmbeddableEnhanced)()) === null || _getEmbeddableEnhance === void 0 ? void 0 : _getEmbeddableEnhance.initializeReactEmbeddableDynamicActions(uuid, () => titleManager.api.title$.getValue(), state);
    const maybeStopDynamicActions = dynamicActionsApi === null || dynamicActionsApi === void 0 ? void 0 : dynamicActionsApi.startDynamicActions();
    const defaultTitle$ = new _rxjs.BehaviorSubject(savedMap.getAttributes().title);
    const defaultDescription$ = new _rxjs.BehaviorSubject(savedMap.getAttributes().description);
    const reduxSync = (0, _initialize_redux_sync.initializeReduxSync)({
      savedMap,
      state,
      syncColors$: (0, _publishes_settings.apiPublishesSettings)(parentApi) ? parentApi.settings.syncColors$ : undefined,
      uuid
    });
    const actionHandlers = (0, _initialize_action_handlers.initializeActionHandlers)(getApi);
    const crossPanelActions = (0, _initialize_cross_panel_actions.initializeCrossPanelActions)({
      controlledBy,
      getActionContext: actionHandlers.getActionContext,
      getApi,
      state,
      savedMap,
      uuid
    });
    function getState() {
      var _dynamicActionsApi$se;
      return {
        ...state,
        ...timeRange.serialize(),
        ...titleManager.serialize(),
        ...((_dynamicActionsApi$se = dynamicActionsApi === null || dynamicActionsApi === void 0 ? void 0 : dynamicActionsApi.serializeDynamicActions()) !== null && _dynamicActionsApi$se !== void 0 ? _dynamicActionsApi$se : {}),
        ...crossPanelActions.serialize(),
        ...reduxSync.serialize()
      };
    }
    function serializeState() {
      const rawState = getState();

      // by-reference embeddable
      if (rawState.savedObjectId) {
        // No references to extract for by-reference embeddable since all references are stored with by-reference saved object
        return {
          rawState: (0, _library_transforms.getByReferenceState)(rawState, rawState.savedObjectId),
          references: []
        };
      }

      /**
       * Canvas by-value embeddables do not support references
       */
      if ((0, _presentationPublishing.apiIsOfType)(parentApi, 'canvas')) {
        return {
          rawState: (0, _library_transforms.getByValueState)(rawState, savedMap.getAttributes()),
          references: []
        };
      }

      // by-value embeddable
      const {
        attributes,
        references
      } = (0, _references.extractReferences)({
        attributes: savedMap.getAttributes()
      });
      return {
        rawState: (0, _library_transforms.getByValueState)(rawState, attributes),
        references
      };
    }
    api = buildApi({
      defaultTitle$,
      defaultDescription$,
      ...timeRange.api,
      ...((_dynamicActionsApi$dy = dynamicActionsApi === null || dynamicActionsApi === void 0 ? void 0 : dynamicActionsApi.dynamicActionsApi) !== null && _dynamicActionsApi$dy !== void 0 ? _dynamicActionsApi$dy : {}),
      ...titleManager.api,
      ...reduxSync.api,
      ...(0, _initialize_edit_api.initializeEditApi)(uuid, getState, parentApi, state.savedObjectId),
      ...(0, _library_transforms.initializeLibraryTransforms)(savedMap, serializeState),
      ...(0, _initialize_data_views.initializeDataViews)(savedMap.getStore()),
      serializeState,
      supportedTriggers: () => {
        return [_public.APPLY_FILTER_TRIGGER, _public2.VALUE_CLICK_TRIGGER];
      }
    }, {
      ...timeRange.comparators,
      ...titleManager.comparators,
      ...((_dynamicActionsApi$dy2 = dynamicActionsApi === null || dynamicActionsApi === void 0 ? void 0 : dynamicActionsApi.dynamicActionsComparator) !== null && _dynamicActionsApi$dy2 !== void 0 ? _dynamicActionsApi$dy2 : {
        enhancements: (0, _presentationPublishing.getUnchangingComparator)()
      }),
      ...crossPanelActions.comparators,
      ...reduxSync.comparators,
      attributes: [attributes$, next => attributes$.next(next)],
      mapSettings: [mapSettings$, next => mapSettings$.next(next)],
      savedObjectId: [savedObjectId$, next => savedObjectId$.next(next)],
      // readonly comparators
      mapBuffer: (0, _presentationPublishing.getUnchangingComparator)()
    });
    const unsubscribeFromFetch = (0, _initialize_fetch.initializeFetch)({
      api,
      controlledBy,
      getIsFilterByMapExtent: crossPanelActions.getIsFilterByMapExtent,
      searchSessionMapBuffer: state.mapBuffer,
      store: savedMap.getStore()
    });
    return {
      api,
      Component: () => {
        const [defaultTitle, title, defaultDescription, description] = (0, _presentationPublishing.useBatchedPublishingSubjects)(defaultTitle$, titleManager.api.title$, defaultDescription$, titleManager.api.description$);
        (0, _react.useEffect)(() => {
          return () => {
            crossPanelActions.cleanup();
            reduxSync.cleanup();
            unsubscribeFromFetch();
            maybeStopDynamicActions === null || maybeStopDynamicActions === void 0 ? void 0 : maybeStopDynamicActions.stopDynamicActions();
          };
        }, []);
        return sharingSavedObjectProps && spaces && (sharingSavedObjectProps === null || sharingSavedObjectProps === void 0 ? void 0 : sharingSavedObjectProps.outcome) === 'conflict' ? /*#__PURE__*/_react.default.createElement("div", {
          className: "mapEmbeddedError"
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
          iconType: "warning",
          iconColor: "danger",
          "data-test-subj": "embeddable-maps-failure",
          body: spaces.ui.components.getEmbeddableLegacyUrlConflict({
            targetType: _constants.MAP_SAVED_OBJECT_TYPE,
            sourceId: sharingSavedObjectProps.sourceId
          })
        })) : /*#__PURE__*/_react.default.createElement(_reactRedux.Provider, {
          store: savedMap.getStore()
        }, /*#__PURE__*/_react.default.createElement(_map_container.MapContainer, {
          onSingleValueTrigger: actionHandlers.onSingleValueTrigger,
          addFilters: (0, _types.isMapRendererApi)(parentApi) && typeof parentApi.hideFilterActions === 'boolean' && parentApi.hideFilterActions || (0, _presentationPublishing.areTriggersDisabled)(api) ? null : actionHandlers.addFilters,
          getFilterActions: actionHandlers.getFilterActions,
          getActionContext: actionHandlers.getActionContext,
          renderTooltipContent: (0, _types.isMapRendererApi)(parentApi) && parentApi.getTooltipRenderer ? parentApi.getTooltipRenderer() : undefined,
          title: title !== null && title !== void 0 ? title : defaultTitle,
          description: description !== null && description !== void 0 ? description : defaultDescription,
          waitUntilTimeLayersLoad$: (0, _wait_until_time_layers_load.waitUntilTimeLayersLoad$)(savedMap.getStore()),
          isSharable: (0, _types.isMapRendererApi)(parentApi) && typeof parentApi.isSharable === 'boolean' ? parentApi.isSharable : true
        }));
      }
    };
  }
};