"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMapsVisTypeAlias = getMapsVisTypeAlias;
var _i18n = require("@kbn/i18n");
var _constants = require("../common/constants");
var _content_management = require("./content_management");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getMapsVisTypeAlias() {
  const appDescription = _i18n.i18n.translate('xpack.maps.visTypeAlias.description', {
    defaultMessage: 'Create and style maps with multiple layers and indices.'
  });
  return {
    alias: {
      app: _constants.APP_ID,
      path: `/${_constants.MAP_PATH}`
    },
    name: _constants.APP_ID,
    title: _constants.APP_NAME,
    description: appDescription,
    icon: _constants.APP_ICON,
    stage: 'production',
    order: 40,
    appExtensions: {
      visualizations: {
        docTypes: [_constants.MAP_SAVED_OBJECT_TYPE],
        searchFields: ['title^3'],
        client: _content_management.getMapClient,
        toListItem(mapItem) {
          const {
            id,
            type,
            updatedAt,
            attributes,
            managed
          } = mapItem;
          const {
            title,
            description
          } = attributes;
          return {
            id,
            title,
            description,
            updatedAt,
            managed,
            editor: {
              editUrl: (0, _constants.getEditPath)(id),
              editApp: _constants.APP_ID
            },
            icon: _constants.APP_ICON,
            stage: 'production',
            savedObjectType: type,
            typeTitle: _constants.APP_NAME
          };
        }
      }
    }
  };
}