"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LabelZoomRangeEditor = LabelZoomRangeEditor;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _get_vector_style_label = require("../get_vector_style_label");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function LabelZoomRangeEditor(props) {
  const layerZoomRange = props.styleProperty.getLayerZoomRange();
  const labelZoomRange = props.styleProperty.getLabelZoomRange();
  const onSwitchChange = event => {
    props.handlePropertyChange(props.styleProperty.getStyleName(), {
      options: {
        ...props.styleProperty.getOptions(),
        useLayerZoomRange: event.target.checked
      }
    });
  };
  const onZoomChange = value => {
    props.handlePropertyChange(props.styleProperty.getStyleName(), {
      options: {
        ...props.styleProperty.getOptions(),
        minZoom: Math.max(layerZoomRange.minZoom, parseInt(value[0], 10)),
        maxZoom: Math.min(layerZoomRange.maxZoom, parseInt(value[1], 10))
      }
    });
  };
  const {
    useLayerZoomRange
  } = props.styleProperty.getOptions();
  const slider = useLayerZoomRange ? null : /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    hasEmptyLabelSpace: true
  }, /*#__PURE__*/_react.default.createElement(_public.ValidatedDualRange, {
    formRowDisplay: "columnCompressed",
    min: layerZoomRange.minZoom,
    max: layerZoomRange.maxZoom,
    value: [labelZoomRange.minZoom, labelZoomRange.maxZoom],
    showInput: "inputWithPopover",
    showRange: true,
    showLabels: true,
    onChange: onZoomChange,
    allowEmptyRange: false,
    compressed: true,
    prepend: _i18n.i18n.translate('xpack.maps.styles.labelZoomRange.visibleZoom', {
      defaultMessage: 'Zoom levels'
    })
  }));
  const form = /*#__PURE__*/_react.default.createElement(_eui.EuiForm, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: (0, _get_vector_style_label.getVectorStyleLabel)(props.styleProperty.getStyleName())
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: _i18n.i18n.translate('xpack.maps.styles.labelZoomRange.useLayerZoomLabel', {
      defaultMessage: 'Use layer visibility'
    }),
    checked: useLayerZoomRange,
    onChange: onSwitchChange,
    compressed: true
  })), slider);
  if (!props.disabled) {
    return form;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    anchorClassName: "mapStyleFormDisabledTooltip",
    content: (0, _get_vector_style_label.getDisabledByMessage)(props.disabledBy)
  }, form);
}