"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CategoricalDataMappingPopover = CategoricalDataMappingPopover;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _data_mapping_popover = require("./data_mapping_popover");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function CategoricalDataMappingPopover(props) {
  const onIsEnabledChange = event => {
    // @ts-expect-error
    props.onChange({
      fieldMetaOptions: {
        ...props.fieldMetaOptions,
        isEnabled: event.target.checked
      }
    });
  };
  return /*#__PURE__*/_react.default.createElement(_data_mapping_popover.DataMappingPopover, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressed"
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: _i18n.i18n.translate('xpack.maps.styles.fieldMetaOptions.isEnabled.categoricalLabel', {
      defaultMessage: 'Get categories from data set'
    }),
    checked: props.fieldMetaOptions.isEnabled,
    onChange: onIsEnabledChange,
    disabled: !props.supportsFieldMetaFromLocalData,
    compressed: true
  }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.maps.styles.categoricalDataMapping.isEnabled.server",
      defaultMessage: "Calculate categories from the entire data set. Styling is consistent when users pan, zoom, and filter."
    })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.maps.styles.categoricalDataMapping.isEnabled.local",
      defaultMessage: "When disabled, calculate categories from local data and recalculate categories when the data changes. Styling may be inconsistent when users pan, zoom, and filter."
    })))
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "questionInCircle",
    color: "subdued"
  })))));
}