"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.pluckOrdinalStyleMeta = pluckOrdinalStyleMeta;
exports.pluckStyleMeta = pluckStyleMeta;
var _constants = require("../../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function pluckStyleMeta(metaFeatures, joinPropertiesMap, supportedShapeTypes, dynamicProperties) {
  const styleMeta = {
    geometryTypes: {
      isPointsOnly: supportedShapeTypes.length === 1 && supportedShapeTypes.includes(_constants.VECTOR_SHAPE_TYPE.POINT),
      isLinesOnly: supportedShapeTypes.length === 1 && supportedShapeTypes.includes(_constants.VECTOR_SHAPE_TYPE.LINE),
      isPolygonsOnly: supportedShapeTypes.length === 1 && supportedShapeTypes.includes(_constants.VECTOR_SHAPE_TYPE.POLYGON)
    },
    fieldMeta: {}
  };
  if (dynamicProperties.length === 0 || !metaFeatures) {
    // no additional meta data to pull from source data request.
    return styleMeta;
  }
  dynamicProperties.forEach(dynamicProperty => {
    const name = dynamicProperty.getFieldName();
    if (!styleMeta.fieldMeta[name]) {
      styleMeta.fieldMeta[name] = {
        categories: []
      };
    }
    const categories = pluckCategoricalStyleMeta(dynamicProperty, metaFeatures, joinPropertiesMap);
    if (categories.length) {
      styleMeta.fieldMeta[name].categories = categories;
    }
    const ordinalStyleMeta = pluckOrdinalStyleMeta(dynamicProperty, metaFeatures, joinPropertiesMap);
    if (ordinalStyleMeta) {
      styleMeta.fieldMeta[name].range = ordinalStyleMeta;
    }
  });
  return styleMeta;
}
function pluckCategoricalStyleMeta(property, metaFeatures, joinPropertiesMap) {
  return [];
}
function pluckOrdinalStyleMeta(property, metaFeatures, joinPropertiesMap) {
  const field = property.getField();
  if (!field || !property.isOrdinal()) {
    return null;
  }
  const isCount = field.isCount();
  let min = isCount ? 1 : Infinity;
  let max = -Infinity;
  if (property.getFieldOrigin() === _constants.FIELD_ORIGIN.SOURCE) {
    for (let i = 0; i < metaFeatures.length; i++) {
      const range = field.pluckRangeFromTileMetaFeature(metaFeatures[i]);
      if (range) {
        if (!isCount) {
          min = Math.min(range.min, min);
        }
        max = Math.max(range.max, max);
      }
    }
  } else if (property.getFieldOrigin() === _constants.FIELD_ORIGIN.JOIN && joinPropertiesMap) {
    joinPropertiesMap.forEach(value => {
      const propertyValue = value[field.getName()];
      if (typeof propertyValue === 'number') {
        if (!isCount) {
          min = Math.min(propertyValue, min);
        }
        max = Math.max(propertyValue, max);
      }
    });
  }
  return min === Infinity || max === -Infinity ? null : {
    min,
    max,
    delta: max - min
  };
}