"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EMSFileField = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _field = require("./field");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class EMSFileField extends _field.AbstractField {
  constructor({
    fieldName,
    source,
    origin
  }) {
    super({
      fieldName,
      origin
    });
    (0, _defineProperty2.default)(this, "_source", void 0);
    this._source = source;
  }
  supportsFieldMetaFromEs() {
    return false;
  }
  supportsFieldMetaFromLocalData() {
    return true;
  }
  getSource() {
    return this._source;
  }
  async getLabel() {
    return this._source.getEmsFieldLabel(this.getName());
  }
}
exports.EMSFileField = EMSFileField;